package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;

public class ClusterPolicyFluentImpl<A extends ClusterPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterPolicyFluent<A>{

    private String apiVersion;
    private String kind;
    private String lastModified;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private List<VisitableBuilder<? extends NamedClusterRole,?>> roles =  new ArrayList<VisitableBuilder<? extends NamedClusterRole,?>>();

    public ClusterPolicyFluentImpl(){
    }
    public ClusterPolicyFluentImpl(ClusterPolicy instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoles(instance.getRoles()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public String getLastModified(){
            return this.lastModified;
    }

    public A withLastModified(String lastModified){
            this.lastModified=lastModified; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public ClusterPolicyFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ClusterPolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ClusterPolicyFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ClusterPolicyFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ClusterPolicyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToRoles(NamedClusterRole... items){
            for (NamedClusterRole item : items) {NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);_visitables.add(builder);this.roles.add(builder);} return (A)this;
    }

    public A removeFromRoles(NamedClusterRole... items){
            for (NamedClusterRole item : items) {NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);_visitables.remove(builder);this.roles.remove(builder);} return (A)this;
    }

    public List<NamedClusterRole> getRoles(){
            return build(roles);
    }

    public A withRoles(List<NamedClusterRole> roles){
            _visitables.removeAll(this.roles);
            this.roles.clear();
            if (roles != null) {for (NamedClusterRole item : roles){this.addToRoles(item);}} return (A) this;
    }

    public A withRoles(NamedClusterRole... roles){
            this.roles.clear(); if (roles != null) {for (NamedClusterRole item :roles){ this.addToRoles(item);}} return (A) this;
    }

    public ClusterPolicyFluent.RolesNested<A> addNewRole(){
            return new RolesNestedImpl();
    }

    public ClusterPolicyFluent.RolesNested<A> addNewRoleLike(NamedClusterRole item){
            return new RolesNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterPolicyFluentImpl that = (ClusterPolicyFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (lastModified != null ? !lastModified.equals(that.lastModified) :that.lastModified != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (roles != null ? !roles.equals(that.roles) :that.roles != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ClusterPolicyFluent.MetadataNested<N>> implements ClusterPolicyFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ClusterPolicyFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class RolesNestedImpl<N> extends NamedClusterRoleFluentImpl<ClusterPolicyFluent.RolesNested<N>> implements ClusterPolicyFluent.RolesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NamedClusterRoleBuilder builder;
    
            RolesNestedImpl(NamedClusterRole item){
                    this.builder = new NamedClusterRoleBuilder(this, item);
            }
            RolesNestedImpl(){
                    this.builder = new NamedClusterRoleBuilder(this);
            }
    
    public N and(){
            return (N) ClusterPolicyFluentImpl.this.addToRoles(builder.build());
    }
    public N endRole(){
            return and();
    }

}


}
