package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface CustomBuildStrategyFluent<A extends CustomBuildStrategyFluent<A>> extends Fluent<A>{


    public String getBuildAPIVersion();
    public A withBuildAPIVersion(String buildAPIVersion);
    public A addToEnv(EnvVar... items);
    public A removeFromEnv(EnvVar... items);
    public List<EnvVar> getEnv();
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public CustomBuildStrategyFluent.EnvNested<A> addNewEnv();
    public CustomBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item);
    public Boolean isExposeDockerSocket();
    public A withExposeDockerSocket(Boolean exposeDockerSocket);
    public Boolean isForcePull();
    public A withForcePull(Boolean forcePull);
    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public CustomBuildStrategyFluent.FromNested<A> withNewFrom();
    public CustomBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public CustomBuildStrategyFluent.FromNested<A> editFrom();
    public CustomBuildStrategyFluent.FromNested<A> editOrNewFrom();
    public CustomBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item);
    public LocalObjectReference getPullSecret();
    public A withPullSecret(LocalObjectReference pullSecret);
    public CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecret();
    public CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
    public CustomBuildStrategyFluent.PullSecretNested<A> editPullSecret();
    public CustomBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret();
    public CustomBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item);
    public A withNewPullSecret(String name);
    public A addToSecrets(SecretSpec... items);
    public A removeFromSecrets(SecretSpec... items);
    public List<SecretSpec> getSecrets();
    public A withSecrets(List<SecretSpec> secrets);
    public A withSecrets(SecretSpec... secrets);
    public CustomBuildStrategyFluent.SecretsNested<A> addNewSecret();
    public CustomBuildStrategyFluent.SecretsNested<A> addNewSecretLike(SecretSpec item);

    public interface EnvNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EnvVarFluent<CustomBuildStrategyFluent.EnvNested<N>>{

        
    public N and();    public N endEnv();
}
    public interface FromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<CustomBuildStrategyFluent.FromNested<N>>{

        
    public N and();    public N endFrom();
}
    public interface PullSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<CustomBuildStrategyFluent.PullSecretNested<N>>{

        
    public N and();    public N endPullSecret();
}
    public interface SecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretSpecFluent<CustomBuildStrategyFluent.SecretsNested<N>>{

        
    public N and();    public N endSecret();
}


}
