package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface DeploymentConfigFluent<A extends DeploymentConfigFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public DeploymentConfigFluent.MetadataNested<A> withNewMetadata();
    public DeploymentConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public DeploymentConfigFluent.MetadataNested<A> editMetadata();
    public DeploymentConfigFluent.MetadataNested<A> editOrNewMetadata();
    public DeploymentConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public DeploymentConfigSpec getSpec();
    public A withSpec(DeploymentConfigSpec spec);
    public DeploymentConfigFluent.SpecNested<A> withNewSpec();
    public DeploymentConfigFluent.SpecNested<A> withNewSpecLike(DeploymentConfigSpec item);
    public DeploymentConfigFluent.SpecNested<A> editSpec();
    public DeploymentConfigFluent.SpecNested<A> editOrNewSpec();
    public DeploymentConfigFluent.SpecNested<A> editOrNewSpecLike(DeploymentConfigSpec item);
    public DeploymentConfigStatus getStatus();
    public A withStatus(DeploymentConfigStatus status);
    public DeploymentConfigFluent.StatusNested<A> withNewStatus();
    public DeploymentConfigFluent.StatusNested<A> withNewStatusLike(DeploymentConfigStatus item);
    public DeploymentConfigFluent.StatusNested<A> editStatus();
    public DeploymentConfigFluent.StatusNested<A> editOrNewStatus();
    public DeploymentConfigFluent.StatusNested<A> editOrNewStatusLike(DeploymentConfigStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<DeploymentConfigFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentConfigSpecFluent<DeploymentConfigFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentConfigStatusFluent<DeploymentConfigFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
