package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class DeploymentConfigStatusBuilder extends DeploymentConfigStatusFluentImpl<DeploymentConfigStatusBuilder> implements VisitableBuilder<DeploymentConfigStatus,DeploymentConfigStatusBuilder>{

    DeploymentConfigStatusFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentConfigStatusBuilder(){
            this(true);
    }
    public DeploymentConfigStatusBuilder(Boolean validationEnabled){
            this(new DeploymentConfigStatus(), validationEnabled);
    }
    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent){
            this(fluent, true);
    }
    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DeploymentConfigStatus(), validationEnabled);
    }
    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent,DeploymentConfigStatus instance){
            this(fluent, instance, true);
    }
    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent,DeploymentConfigStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
            fluent.withDetails(instance.getDetails()); 
            fluent.withLatestVersion(instance.getLatestVersion()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withReplicas(instance.getReplicas()); 
            fluent.withUnavailableReplicas(instance.getUnavailableReplicas()); 
            fluent.withUpdatedReplicas(instance.getUpdatedReplicas()); 
            this.validationEnabled = validationEnabled; 
    }
    public DeploymentConfigStatusBuilder(DeploymentConfigStatus instance){
            this(instance,true);
    }
    public DeploymentConfigStatusBuilder(DeploymentConfigStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAvailableReplicas(instance.getAvailableReplicas()); 
            this.withDetails(instance.getDetails()); 
            this.withLatestVersion(instance.getLatestVersion()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReplicas(instance.getReplicas()); 
            this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
            this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
            this.validationEnabled = validationEnabled; 
    }

    public DeploymentConfigStatus build(){
            DeploymentConfigStatus buildable = new DeploymentConfigStatus(fluent.getAvailableReplicas(),fluent.getDetails(),fluent.getLatestVersion(),fluent.getObservedGeneration(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentConfigStatusBuilder that = (DeploymentConfigStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
