package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class ExecNewPodHookFluentImpl<A extends ExecNewPodHookFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExecNewPodHookFluent<A>{

    private List<String> command = new ArrayList<String>();
    private String containerName;
    private List<VisitableBuilder<? extends EnvVar,?>> env =  new ArrayList<VisitableBuilder<? extends EnvVar,?>>();
    private List<String> volumes = new ArrayList<String>();

    public ExecNewPodHookFluentImpl(){
    }
    public ExecNewPodHookFluentImpl(ExecNewPodHook instance){
            this.withCommand(instance.getCommand()); 
            this.withContainerName(instance.getContainerName()); 
            this.withEnv(instance.getEnv()); 
            this.withVolumes(instance.getVolumes()); 
    }

    public A addToCommand(String... items){
            for (String item : items) {this.command.add(item);} return (A)this;
    }

    public A removeFromCommand(String... items){
            for (String item : items) {this.command.remove(item);} return (A)this;
    }

    public List<String> getCommand(){
            return this.command;
    }

    public A withCommand(List<String> command){
            this.command.clear();
            if (command != null) {for (String item : command){this.addToCommand(item);}} return (A) this;
    }

    public A withCommand(String... command){
            this.command.clear(); if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
    }

    public String getContainerName(){
            return this.containerName;
    }

    public A withContainerName(String containerName){
            this.containerName=containerName; return (A) this;
    }

    public A addToEnv(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.env.remove(builder);} return (A)this;
    }

    public List<EnvVar> getEnv(){
            return build(env);
    }

    public A withEnv(List<EnvVar> env){
            _visitables.removeAll(this.env);
            this.env.clear();
            if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (A) this;
    }

    public A withEnv(EnvVar... env){
            this.env.clear(); if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public ExecNewPodHookFluent.EnvNested<A> addNewEnv(){
            return new EnvNestedImpl();
    }

    public ExecNewPodHookFluent.EnvNested<A> addNewEnvLike(EnvVar item){
            return new EnvNestedImpl(item);
    }

    public A addToVolumes(String... items){
            for (String item : items) {this.volumes.add(item);} return (A)this;
    }

    public A removeFromVolumes(String... items){
            for (String item : items) {this.volumes.remove(item);} return (A)this;
    }

    public List<String> getVolumes(){
            return this.volumes;
    }

    public A withVolumes(List<String> volumes){
            this.volumes.clear();
            if (volumes != null) {for (String item : volumes){this.addToVolumes(item);}} return (A) this;
    }

    public A withVolumes(String... volumes){
            this.volumes.clear(); if (volumes != null) {for (String item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExecNewPodHookFluentImpl that = (ExecNewPodHookFluentImpl) o;
            if (command != null ? !command.equals(that.command) :that.command != null) return false;
            if (containerName != null ? !containerName.equals(that.containerName) :that.containerName != null) return false;
            if (env != null ? !env.equals(that.env) :that.env != null) return false;
            if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
            return true;
    }


    public class EnvNestedImpl<N> extends EnvVarFluentImpl<ExecNewPodHookFluent.EnvNested<N>> implements ExecNewPodHookFluent.EnvNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EnvVarBuilder builder;
    
            EnvNestedImpl(EnvVar item){
                    this.builder = new EnvVarBuilder(this, item);
            }
            EnvNestedImpl(){
                    this.builder = new EnvVarBuilder(this);
            }
    
    public N and(){
            return (N) ExecNewPodHookFluentImpl.this.addToEnv(builder.build());
    }
    public N endEnv(){
            return and();
    }

}


}
