package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ImageFluent<A extends ImageFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getDockerImageConfig();
    public A withDockerImageConfig(String dockerImageConfig);
    public A addToDockerImageLayers(ImageLayer... items);
    public A removeFromDockerImageLayers(ImageLayer... items);
    public List<ImageLayer> getDockerImageLayers();
    public A withDockerImageLayers(List<ImageLayer> dockerImageLayers);
    public A withDockerImageLayers(ImageLayer... dockerImageLayers);
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayer();
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayerLike(ImageLayer item);
    public A addNewDockerImageLayer(String mediaType,String name,Long size);
    public String getDockerImageManifest();
    public A withDockerImageManifest(String dockerImageManifest);
    public String getDockerImageManifestMediaType();
    public A withDockerImageManifestMediaType(String dockerImageManifestMediaType);
    public String getDockerImageMetadataVersion();
    public A withDockerImageMetadataVersion(String dockerImageMetadataVersion);
    public String getDockerImageReference();
    public A withDockerImageReference(String dockerImageReference);
    public A addToDockerImageSignatures(String... items);
    public A removeFromDockerImageSignatures(String... items);
    public List<String> getDockerImageSignatures();
    public A withDockerImageSignatures(List<String> dockerImageSignatures);
    public A withDockerImageSignatures(String... dockerImageSignatures);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ImageFluent.MetadataNested<A> withNewMetadata();
    public ImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ImageFluent.MetadataNested<A> editMetadata();
    public ImageFluent.MetadataNested<A> editOrNewMetadata();
    public ImageFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToSignatures(ImageSignature... items);
    public A removeFromSignatures(ImageSignature... items);
    public List<ImageSignature> getSignatures();
    public A withSignatures(List<ImageSignature> signatures);
    public A withSignatures(ImageSignature... signatures);
    public ImageFluent.SignaturesNested<A> addNewSignature();
    public ImageFluent.SignaturesNested<A> addNewSignatureLike(ImageSignature item);

    public interface DockerImageLayersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageLayerFluent<ImageFluent.DockerImageLayersNested<N>>{

        
    public N and();    public N endDockerImageLayer();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ImageFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SignaturesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSignatureFluent<ImageFluent.SignaturesNested<N>>{

        
    public N and();    public N endSignature();
}


}
