package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;

public class ImageFluentImpl<A extends ImageFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageFluent<A>{

    private String apiVersion;
    private String dockerImageConfig;
    private List<VisitableBuilder<? extends ImageLayer,?>> dockerImageLayers =  new ArrayList<VisitableBuilder<? extends ImageLayer,?>>();
    private String dockerImageManifest;
    private String dockerImageManifestMediaType;
    private String dockerImageMetadataVersion;
    private String dockerImageReference;
    private List<String> dockerImageSignatures = new ArrayList<String>();
    private String kind;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private List<VisitableBuilder<? extends ImageSignature,?>> signatures =  new ArrayList<VisitableBuilder<? extends ImageSignature,?>>();

    public ImageFluentImpl(){
    }
    public ImageFluentImpl(Image instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withDockerImageConfig(instance.getDockerImageConfig()); 
            this.withDockerImageLayers(instance.getDockerImageLayers()); 
            this.withDockerImageManifest(instance.getDockerImageManifest()); 
            this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType()); 
            this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion()); 
            this.withDockerImageReference(instance.getDockerImageReference()); 
            this.withDockerImageSignatures(instance.getDockerImageSignatures()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSignatures(instance.getSignatures()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getDockerImageConfig(){
            return this.dockerImageConfig;
    }

    public A withDockerImageConfig(String dockerImageConfig){
            this.dockerImageConfig=dockerImageConfig; return (A) this;
    }

    public A addToDockerImageLayers(ImageLayer... items){
            for (ImageLayer item : items) {ImageLayerBuilder builder = new ImageLayerBuilder(item);_visitables.add(builder);this.dockerImageLayers.add(builder);} return (A)this;
    }

    public A removeFromDockerImageLayers(ImageLayer... items){
            for (ImageLayer item : items) {ImageLayerBuilder builder = new ImageLayerBuilder(item);_visitables.remove(builder);this.dockerImageLayers.remove(builder);} return (A)this;
    }

    public List<ImageLayer> getDockerImageLayers(){
            return build(dockerImageLayers);
    }

    public A withDockerImageLayers(List<ImageLayer> dockerImageLayers){
            _visitables.removeAll(this.dockerImageLayers);
            this.dockerImageLayers.clear();
            if (dockerImageLayers != null) {for (ImageLayer item : dockerImageLayers){this.addToDockerImageLayers(item);}} return (A) this;
    }

    public A withDockerImageLayers(ImageLayer... dockerImageLayers){
            this.dockerImageLayers.clear(); if (dockerImageLayers != null) {for (ImageLayer item :dockerImageLayers){ this.addToDockerImageLayers(item);}} return (A) this;
    }

    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayer(){
            return new DockerImageLayersNestedImpl();
    }

    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayerLike(ImageLayer item){
            return new DockerImageLayersNestedImpl(item);
    }

    public A addNewDockerImageLayer(String mediaType,String name,Long size){
            return (A)addToDockerImageLayers(new ImageLayer(mediaType, name, size));
    }

    public String getDockerImageManifest(){
            return this.dockerImageManifest;
    }

    public A withDockerImageManifest(String dockerImageManifest){
            this.dockerImageManifest=dockerImageManifest; return (A) this;
    }

    public String getDockerImageManifestMediaType(){
            return this.dockerImageManifestMediaType;
    }

    public A withDockerImageManifestMediaType(String dockerImageManifestMediaType){
            this.dockerImageManifestMediaType=dockerImageManifestMediaType; return (A) this;
    }

    public String getDockerImageMetadataVersion(){
            return this.dockerImageMetadataVersion;
    }

    public A withDockerImageMetadataVersion(String dockerImageMetadataVersion){
            this.dockerImageMetadataVersion=dockerImageMetadataVersion; return (A) this;
    }

    public String getDockerImageReference(){
            return this.dockerImageReference;
    }

    public A withDockerImageReference(String dockerImageReference){
            this.dockerImageReference=dockerImageReference; return (A) this;
    }

    public A addToDockerImageSignatures(String... items){
            for (String item : items) {this.dockerImageSignatures.add(item);} return (A)this;
    }

    public A removeFromDockerImageSignatures(String... items){
            for (String item : items) {this.dockerImageSignatures.remove(item);} return (A)this;
    }

    public List<String> getDockerImageSignatures(){
            return this.dockerImageSignatures;
    }

    public A withDockerImageSignatures(List<String> dockerImageSignatures){
            this.dockerImageSignatures.clear();
            if (dockerImageSignatures != null) {for (String item : dockerImageSignatures){this.addToDockerImageSignatures(item);}} return (A) this;
    }

    public A withDockerImageSignatures(String... dockerImageSignatures){
            this.dockerImageSignatures.clear(); if (dockerImageSignatures != null) {for (String item :dockerImageSignatures){ this.addToDockerImageSignatures(item);}} return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public ImageFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ImageFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ImageFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ImageFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToSignatures(ImageSignature... items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.add(builder);this.signatures.add(builder);} return (A)this;
    }

    public A removeFromSignatures(ImageSignature... items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.remove(builder);this.signatures.remove(builder);} return (A)this;
    }

    public List<ImageSignature> getSignatures(){
            return build(signatures);
    }

    public A withSignatures(List<ImageSignature> signatures){
            _visitables.removeAll(this.signatures);
            this.signatures.clear();
            if (signatures != null) {for (ImageSignature item : signatures){this.addToSignatures(item);}} return (A) this;
    }

    public A withSignatures(ImageSignature... signatures){
            this.signatures.clear(); if (signatures != null) {for (ImageSignature item :signatures){ this.addToSignatures(item);}} return (A) this;
    }

    public ImageFluent.SignaturesNested<A> addNewSignature(){
            return new SignaturesNestedImpl();
    }

    public ImageFluent.SignaturesNested<A> addNewSignatureLike(ImageSignature item){
            return new SignaturesNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageFluentImpl that = (ImageFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (dockerImageConfig != null ? !dockerImageConfig.equals(that.dockerImageConfig) :that.dockerImageConfig != null) return false;
            if (dockerImageLayers != null ? !dockerImageLayers.equals(that.dockerImageLayers) :that.dockerImageLayers != null) return false;
            if (dockerImageManifest != null ? !dockerImageManifest.equals(that.dockerImageManifest) :that.dockerImageManifest != null) return false;
            if (dockerImageManifestMediaType != null ? !dockerImageManifestMediaType.equals(that.dockerImageManifestMediaType) :that.dockerImageManifestMediaType != null) return false;
            if (dockerImageMetadataVersion != null ? !dockerImageMetadataVersion.equals(that.dockerImageMetadataVersion) :that.dockerImageMetadataVersion != null) return false;
            if (dockerImageReference != null ? !dockerImageReference.equals(that.dockerImageReference) :that.dockerImageReference != null) return false;
            if (dockerImageSignatures != null ? !dockerImageSignatures.equals(that.dockerImageSignatures) :that.dockerImageSignatures != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (signatures != null ? !signatures.equals(that.signatures) :that.signatures != null) return false;
            return true;
    }


    public class DockerImageLayersNestedImpl<N> extends ImageLayerFluentImpl<ImageFluent.DockerImageLayersNested<N>> implements ImageFluent.DockerImageLayersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageLayerBuilder builder;
    
            DockerImageLayersNestedImpl(ImageLayer item){
                    this.builder = new ImageLayerBuilder(this, item);
            }
            DockerImageLayersNestedImpl(){
                    this.builder = new ImageLayerBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.addToDockerImageLayers(builder.build());
    }
    public N endDockerImageLayer(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ImageFluent.MetadataNested<N>> implements ImageFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SignaturesNestedImpl<N> extends ImageSignatureFluentImpl<ImageFluent.SignaturesNested<N>> implements ImageFluent.SignaturesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageSignatureBuilder builder;
    
            SignaturesNestedImpl(ImageSignature item){
                    this.builder = new ImageSignatureBuilder(this, item);
            }
            SignaturesNestedImpl(){
                    this.builder = new ImageSignatureBuilder(this);
            }
    
    public N and(){
            return (N) ImageFluentImpl.this.addToSignatures(builder.build());
    }
    public N endSignature(){
            return and();
    }

}


}
