package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface OAuthAccessTokenFluent<A extends OAuthAccessTokenFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getAuthorizeToken();
    public A withAuthorizeToken(String authorizeToken);
    public String getClientName();
    public A withClientName(String clientName);
    public Long getExpiresIn();
    public A withExpiresIn(Long expiresIn);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public OAuthAccessTokenFluent.MetadataNested<A> withNewMetadata();
    public OAuthAccessTokenFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OAuthAccessTokenFluent.MetadataNested<A> editMetadata();
    public OAuthAccessTokenFluent.MetadataNested<A> editOrNewMetadata();
    public OAuthAccessTokenFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public String getRedirectURI();
    public A withRedirectURI(String redirectURI);
    public String getRefreshToken();
    public A withRefreshToken(String refreshToken);
    public A addToScopes(String... items);
    public A removeFromScopes(String... items);
    public List<String> getScopes();
    public A withScopes(List<String> scopes);
    public A withScopes(String... scopes);
    public String getUserName();
    public A withUserName(String userName);
    public String getUserUID();
    public A withUserUID(String userUID);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<OAuthAccessTokenFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
