package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface OAuthAuthorizeTokenFluent<A extends OAuthAuthorizeTokenFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getClientName();
    public A withClientName(String clientName);
    public Long getExpiresIn();
    public A withExpiresIn(Long expiresIn);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public OAuthAuthorizeTokenFluent.MetadataNested<A> withNewMetadata();
    public OAuthAuthorizeTokenFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OAuthAuthorizeTokenFluent.MetadataNested<A> editMetadata();
    public OAuthAuthorizeTokenFluent.MetadataNested<A> editOrNewMetadata();
    public OAuthAuthorizeTokenFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public String getRedirectURI();
    public A withRedirectURI(String redirectURI);
    public A addToScopes(String... items);
    public A removeFromScopes(String... items);
    public List<String> getScopes();
    public A withScopes(List<String> scopes);
    public A withScopes(String... scopes);
    public String getState();
    public A withState(String state);
    public String getUserName();
    public A withUserName(String userName);
    public String getUserUID();
    public A withUserUID(String userUID);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<OAuthAuthorizeTokenFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
