package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class SecretSpecBuilder extends SecretSpecFluentImpl<SecretSpecBuilder> implements VisitableBuilder<SecretSpec,SecretSpecBuilder>{

    SecretSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SecretSpecBuilder(){
            this(true);
    }
    public SecretSpecBuilder(Boolean validationEnabled){
            this(new SecretSpec(), validationEnabled);
    }
    public SecretSpecBuilder(SecretSpecFluent<?> fluent){
            this(fluent, true);
    }
    public SecretSpecBuilder(SecretSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SecretSpec(), validationEnabled);
    }
    public SecretSpecBuilder(SecretSpecFluent<?> fluent,SecretSpec instance){
            this(fluent, instance, true);
    }
    public SecretSpecBuilder(SecretSpecFluent<?> fluent,SecretSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMountPath(instance.getMountPath()); 
            fluent.withSecretSource(instance.getSecretSource()); 
            this.validationEnabled = validationEnabled; 
    }
    public SecretSpecBuilder(SecretSpec instance){
            this(instance,true);
    }
    public SecretSpecBuilder(SecretSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMountPath(instance.getMountPath()); 
            this.withSecretSource(instance.getSecretSource()); 
            this.validationEnabled = validationEnabled; 
    }

    public SecretSpec build(){
            SecretSpec buildable = new SecretSpec(fluent.getMountPath(),fluent.getSecretSource());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SecretSpecBuilder that = (SecretSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
