package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import java.lang.Object;
import lombok.ToString;

public class SourceBuildStrategyFluentImpl<A extends SourceBuildStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SourceBuildStrategyFluent<A>{

    private List<VisitableBuilder<? extends EnvVar,?>> env =  new ArrayList<VisitableBuilder<? extends EnvVar,?>>();
    private Boolean forcePull;
    private VisitableBuilder<? extends ObjectReference,?> from;
    private Boolean incremental;
    private VisitableBuilder<? extends LocalObjectReference,?> pullSecret;
    private List<VisitableBuilder<? extends ImageSourcePath,?>> runtimeArtifacts =  new ArrayList<VisitableBuilder<? extends ImageSourcePath,?>>();
    private VisitableBuilder<? extends ObjectReference,?> runtimeImage;
    private String scripts;

    public SourceBuildStrategyFluentImpl(){
    }
    public SourceBuildStrategyFluentImpl(SourceBuildStrategy instance){
            this.withEnv(instance.getEnv()); 
            this.withForcePull(instance.getForcePull()); 
            this.withFrom(instance.getFrom()); 
            this.withIncremental(instance.getIncremental()); 
            this.withPullSecret(instance.getPullSecret()); 
            this.withRuntimeArtifacts(instance.getRuntimeArtifacts()); 
            this.withRuntimeImage(instance.getRuntimeImage()); 
            this.withScripts(instance.getScripts()); 
    }

    public A addToEnv(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.env.remove(builder);} return (A)this;
    }

    public List<EnvVar> getEnv(){
            return build(env);
    }

    public A withEnv(List<EnvVar> env){
            _visitables.removeAll(this.env);
            this.env.clear();
            if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (A) this;
    }

    public A withEnv(EnvVar... env){
            this.env.clear(); if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public SourceBuildStrategyFluent.EnvNested<A> addNewEnv(){
            return new EnvNestedImpl();
    }

    public SourceBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item){
            return new EnvNestedImpl(item);
    }

    public Boolean isForcePull(){
            return this.forcePull;
    }

    public A withForcePull(Boolean forcePull){
            this.forcePull=forcePull; return (A) this;
    }

    public ObjectReference getFrom(){
            return this.from!=null?this.from.build():null;
    }

    public A withFrom(ObjectReference from){
            _visitables.remove(this.from);
            if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }

    public SourceBuildStrategyFluent.FromNested<A> withNewFrom(){
            return new FromNestedImpl();
    }

    public SourceBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item){
            return new FromNestedImpl(item);
    }

    public SourceBuildStrategyFluent.FromNested<A> editFrom(){
            return withNewFromLike(getFrom());
    }

    public SourceBuildStrategyFluent.FromNested<A> editOrNewFrom(){
            return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
    }

    public SourceBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item){
            return withNewFromLike(getFrom() != null ? getFrom(): item);
    }

    public Boolean isIncremental(){
            return this.incremental;
    }

    public A withIncremental(Boolean incremental){
            this.incremental=incremental; return (A) this;
    }

    public LocalObjectReference getPullSecret(){
            return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public A withPullSecret(LocalObjectReference pullSecret){
            _visitables.remove(this.pullSecret);
            if (pullSecret!=null){ this.pullSecret= new LocalObjectReferenceBuilder(pullSecret); _visitables.add(this.pullSecret);} return (A) this;
    }

    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecret(){
            return new PullSecretNestedImpl();
    }

    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item){
            return new PullSecretNestedImpl(item);
    }

    public SourceBuildStrategyFluent.PullSecretNested<A> editPullSecret(){
            return withNewPullSecretLike(getPullSecret());
    }

    public SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret(){
            return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new LocalObjectReferenceBuilder().build());
    }

    public SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item){
            return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
    }

    public A withNewPullSecret(String name){
            return (A)withPullSecret(new LocalObjectReference(name));
    }

    public A addToRuntimeArtifacts(ImageSourcePath... items){
            for (ImageSourcePath item : items) {ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);_visitables.add(builder);this.runtimeArtifacts.add(builder);} return (A)this;
    }

    public A removeFromRuntimeArtifacts(ImageSourcePath... items){
            for (ImageSourcePath item : items) {ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);_visitables.remove(builder);this.runtimeArtifacts.remove(builder);} return (A)this;
    }

    public List<ImageSourcePath> getRuntimeArtifacts(){
            return build(runtimeArtifacts);
    }

    public A withRuntimeArtifacts(List<ImageSourcePath> runtimeArtifacts){
            _visitables.removeAll(this.runtimeArtifacts);
            this.runtimeArtifacts.clear();
            if (runtimeArtifacts != null) {for (ImageSourcePath item : runtimeArtifacts){this.addToRuntimeArtifacts(item);}} return (A) this;
    }

    public A withRuntimeArtifacts(ImageSourcePath... runtimeArtifacts){
            this.runtimeArtifacts.clear(); if (runtimeArtifacts != null) {for (ImageSourcePath item :runtimeArtifacts){ this.addToRuntimeArtifacts(item);}} return (A) this;
    }

    public SourceBuildStrategyFluent.RuntimeArtifactsNested<A> addNewRuntimeArtifact(){
            return new RuntimeArtifactsNestedImpl();
    }

    public SourceBuildStrategyFluent.RuntimeArtifactsNested<A> addNewRuntimeArtifactLike(ImageSourcePath item){
            return new RuntimeArtifactsNestedImpl(item);
    }

    public A addNewRuntimeArtifact(String destinationDir,String sourcePath){
            return (A)addToRuntimeArtifacts(new ImageSourcePath(destinationDir, sourcePath));
    }

    public ObjectReference getRuntimeImage(){
            return this.runtimeImage!=null?this.runtimeImage.build():null;
    }

    public A withRuntimeImage(ObjectReference runtimeImage){
            _visitables.remove(this.runtimeImage);
            if (runtimeImage!=null){ this.runtimeImage= new ObjectReferenceBuilder(runtimeImage); _visitables.add(this.runtimeImage);} return (A) this;
    }

    public SourceBuildStrategyFluent.RuntimeImageNested<A> withNewRuntimeImage(){
            return new RuntimeImageNestedImpl();
    }

    public SourceBuildStrategyFluent.RuntimeImageNested<A> withNewRuntimeImageLike(ObjectReference item){
            return new RuntimeImageNestedImpl(item);
    }

    public SourceBuildStrategyFluent.RuntimeImageNested<A> editRuntimeImage(){
            return withNewRuntimeImageLike(getRuntimeImage());
    }

    public SourceBuildStrategyFluent.RuntimeImageNested<A> editOrNewRuntimeImage(){
            return withNewRuntimeImageLike(getRuntimeImage() != null ? getRuntimeImage(): new ObjectReferenceBuilder().build());
    }

    public SourceBuildStrategyFluent.RuntimeImageNested<A> editOrNewRuntimeImageLike(ObjectReference item){
            return withNewRuntimeImageLike(getRuntimeImage() != null ? getRuntimeImage(): item);
    }

    public String getScripts(){
            return this.scripts;
    }

    public A withScripts(String scripts){
            this.scripts=scripts; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SourceBuildStrategyFluentImpl that = (SourceBuildStrategyFluentImpl) o;
            if (env != null ? !env.equals(that.env) :that.env != null) return false;
            if (forcePull != null ? !forcePull.equals(that.forcePull) :that.forcePull != null) return false;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (incremental != null ? !incremental.equals(that.incremental) :that.incremental != null) return false;
            if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
            if (runtimeArtifacts != null ? !runtimeArtifacts.equals(that.runtimeArtifacts) :that.runtimeArtifacts != null) return false;
            if (runtimeImage != null ? !runtimeImage.equals(that.runtimeImage) :that.runtimeImage != null) return false;
            if (scripts != null ? !scripts.equals(that.scripts) :that.scripts != null) return false;
            return true;
    }


    public class EnvNestedImpl<N> extends EnvVarFluentImpl<SourceBuildStrategyFluent.EnvNested<N>> implements SourceBuildStrategyFluent.EnvNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EnvVarBuilder builder;
    
            EnvNestedImpl(EnvVar item){
                    this.builder = new EnvVarBuilder(this, item);
            }
            EnvNestedImpl(){
                    this.builder = new EnvVarBuilder(this);
            }
    
    public N and(){
            return (N) SourceBuildStrategyFluentImpl.this.addToEnv(builder.build());
    }
    public N endEnv(){
            return and();
    }

}
    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<SourceBuildStrategyFluent.FromNested<N>> implements SourceBuildStrategyFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            FromNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            FromNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) SourceBuildStrategyFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom(){
            return and();
    }

}
    public class PullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<SourceBuildStrategyFluent.PullSecretNested<N>> implements SourceBuildStrategyFluent.PullSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LocalObjectReferenceBuilder builder;
    
            PullSecretNestedImpl(LocalObjectReference item){
                    this.builder = new LocalObjectReferenceBuilder(this, item);
            }
            PullSecretNestedImpl(){
                    this.builder = new LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) SourceBuildStrategyFluentImpl.this.withPullSecret(builder.build());
    }
    public N endPullSecret(){
            return and();
    }

}
    public class RuntimeArtifactsNestedImpl<N> extends ImageSourcePathFluentImpl<SourceBuildStrategyFluent.RuntimeArtifactsNested<N>> implements SourceBuildStrategyFluent.RuntimeArtifactsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageSourcePathBuilder builder;
    
            RuntimeArtifactsNestedImpl(ImageSourcePath item){
                    this.builder = new ImageSourcePathBuilder(this, item);
            }
            RuntimeArtifactsNestedImpl(){
                    this.builder = new ImageSourcePathBuilder(this);
            }
    
    public N and(){
            return (N) SourceBuildStrategyFluentImpl.this.addToRuntimeArtifacts(builder.build());
    }
    public N endRuntimeArtifact(){
            return and();
    }

}
    public class RuntimeImageNestedImpl<N> extends ObjectReferenceFluentImpl<SourceBuildStrategyFluent.RuntimeImageNested<N>> implements SourceBuildStrategyFluent.RuntimeImageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            RuntimeImageNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            RuntimeImageNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) SourceBuildStrategyFluentImpl.this.withRuntimeImage(builder.build());
    }
    public N endRuntimeImage(){
            return and();
    }

}


}
