package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ConfigMapListFluent<A extends ConfigMapListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ConfigMap... items);
    public A removeFromItems(ConfigMap... items);
    public List<ConfigMap> getItems();
    public A withItems(List<ConfigMap> items);
    public A withItems(ConfigMap... items);
    public ConfigMapListFluent.ItemsNested<A> addNewItem();
    public ConfigMapListFluent.ItemsNested<A> addNewItemLike(ConfigMap item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ConfigMapListFluent.MetadataNested<A> withNewMetadata();
    public ConfigMapListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ConfigMapListFluent.MetadataNested<A> editMetadata();
    public ConfigMapListFluent.MetadataNested<A> editOrNewMetadata();
    public ConfigMapListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigMapFluent<ConfigMapListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<ConfigMapListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
