package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;

public class EndpointSubsetFluentImpl<A extends EndpointSubsetFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EndpointSubsetFluent<A>{

    private List<VisitableBuilder<? extends EndpointAddress,?>> addresses =  new ArrayList<VisitableBuilder<? extends EndpointAddress,?>>();
    private List<VisitableBuilder<? extends EndpointAddress,?>> notReadyAddresses =  new ArrayList<VisitableBuilder<? extends EndpointAddress,?>>();
    private List<VisitableBuilder<? extends EndpointPort,?>> ports =  new ArrayList<VisitableBuilder<? extends EndpointPort,?>>();

    public EndpointSubsetFluentImpl(){
    }
    public EndpointSubsetFluentImpl(EndpointSubset instance){
            this.withAddresses(instance.getAddresses()); 
            this.withNotReadyAddresses(instance.getNotReadyAddresses()); 
            this.withPorts(instance.getPorts()); 
    }

    public A addToAddresses(EndpointAddress... items){
            for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.add(builder);this.addresses.add(builder);} return (A)this;
    }

    public A removeFromAddresses(EndpointAddress... items){
            for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.remove(builder);this.addresses.remove(builder);} return (A)this;
    }

    public List<EndpointAddress> getAddresses(){
            return build(addresses);
    }

    public A withAddresses(List<EndpointAddress> addresses){
            _visitables.removeAll(this.addresses);
            this.addresses.clear();
            if (addresses != null) {for (EndpointAddress item : addresses){this.addToAddresses(item);}} return (A) this;
    }

    public A withAddresses(EndpointAddress... addresses){
            this.addresses.clear(); if (addresses != null) {for (EndpointAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
    }

    public EndpointSubsetFluent.AddressesNested<A> addNewAddress(){
            return new AddressesNestedImpl();
    }

    public EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(EndpointAddress item){
            return new AddressesNestedImpl(item);
    }

    public A addToNotReadyAddresses(EndpointAddress... items){
            for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.add(builder);this.notReadyAddresses.add(builder);} return (A)this;
    }

    public A removeFromNotReadyAddresses(EndpointAddress... items){
            for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.remove(builder);this.notReadyAddresses.remove(builder);} return (A)this;
    }

    public List<EndpointAddress> getNotReadyAddresses(){
            return build(notReadyAddresses);
    }

    public A withNotReadyAddresses(List<EndpointAddress> notReadyAddresses){
            _visitables.removeAll(this.notReadyAddresses);
            this.notReadyAddresses.clear();
            if (notReadyAddresses != null) {for (EndpointAddress item : notReadyAddresses){this.addToNotReadyAddresses(item);}} return (A) this;
    }

    public A withNotReadyAddresses(EndpointAddress... notReadyAddresses){
            this.notReadyAddresses.clear(); if (notReadyAddresses != null) {for (EndpointAddress item :notReadyAddresses){ this.addToNotReadyAddresses(item);}} return (A) this;
    }

    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress(){
            return new NotReadyAddressesNestedImpl();
    }

    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(EndpointAddress item){
            return new NotReadyAddressesNestedImpl(item);
    }

    public A addToPorts(EndpointPort... items){
            for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(EndpointPort... items){
            for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.remove(builder);this.ports.remove(builder);} return (A)this;
    }

    public List<EndpointPort> getPorts(){
            return build(ports);
    }

    public A withPorts(List<EndpointPort> ports){
            _visitables.removeAll(this.ports);
            this.ports.clear();
            if (ports != null) {for (EndpointPort item : ports){this.addToPorts(item);}} return (A) this;
    }

    public A withPorts(EndpointPort... ports){
            this.ports.clear(); if (ports != null) {for (EndpointPort item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public EndpointSubsetFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public EndpointSubsetFluent.PortsNested<A> addNewPortLike(EndpointPort item){
            return new PortsNestedImpl(item);
    }

    public A addNewPort(String name,Integer port,String protocol){
            return (A)addToPorts(new EndpointPort(name, port, protocol));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EndpointSubsetFluentImpl that = (EndpointSubsetFluentImpl) o;
            if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
            if (notReadyAddresses != null ? !notReadyAddresses.equals(that.notReadyAddresses) :that.notReadyAddresses != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            return true;
    }


    public class AddressesNestedImpl<N> extends EndpointAddressFluentImpl<EndpointSubsetFluent.AddressesNested<N>> implements EndpointSubsetFluent.AddressesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EndpointAddressBuilder builder;
    
            AddressesNestedImpl(EndpointAddress item){
                    this.builder = new EndpointAddressBuilder(this, item);
            }
            AddressesNestedImpl(){
                    this.builder = new EndpointAddressBuilder(this);
            }
    
    public N and(){
            return (N) EndpointSubsetFluentImpl.this.addToAddresses(builder.build());
    }
    public N endAddress(){
            return and();
    }

}
    public class NotReadyAddressesNestedImpl<N> extends EndpointAddressFluentImpl<EndpointSubsetFluent.NotReadyAddressesNested<N>> implements EndpointSubsetFluent.NotReadyAddressesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EndpointAddressBuilder builder;
    
            NotReadyAddressesNestedImpl(EndpointAddress item){
                    this.builder = new EndpointAddressBuilder(this, item);
            }
            NotReadyAddressesNestedImpl(){
                    this.builder = new EndpointAddressBuilder(this);
            }
    
    public N and(){
            return (N) EndpointSubsetFluentImpl.this.addToNotReadyAddresses(builder.build());
    }
    public N endNotReadyAddress(){
            return and();
    }

}
    public class PortsNestedImpl<N> extends EndpointPortFluentImpl<EndpointSubsetFluent.PortsNested<N>> implements EndpointSubsetFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EndpointPortBuilder builder;
    
            PortsNestedImpl(EndpointPort item){
                    this.builder = new EndpointPortBuilder(this, item);
            }
            PortsNestedImpl(){
                    this.builder = new EndpointPortBuilder(this);
            }
    
    public N and(){
            return (N) EndpointSubsetFluentImpl.this.addToPorts(builder.build());
    }
    public N endPort(){
            return and();
    }

}


}
