package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;

public class EnvVarSourceFluentImpl<A extends EnvVarSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EnvVarSourceFluent<A>{

    private VisitableBuilder<? extends ConfigMapKeySelector,?> configMapKeyRef;
    private VisitableBuilder<? extends ObjectFieldSelector,?> fieldRef;
    private VisitableBuilder<? extends ResourceFieldSelector,?> resourceFieldRef;
    private VisitableBuilder<? extends SecretKeySelector,?> secretKeyRef;

    public EnvVarSourceFluentImpl(){
    }
    public EnvVarSourceFluentImpl(EnvVarSource instance){
            this.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
            this.withFieldRef(instance.getFieldRef()); 
            this.withResourceFieldRef(instance.getResourceFieldRef()); 
            this.withSecretKeyRef(instance.getSecretKeyRef()); 
    }

    public ConfigMapKeySelector getConfigMapKeyRef(){
            return this.configMapKeyRef!=null?this.configMapKeyRef.build():null;
    }

    public A withConfigMapKeyRef(ConfigMapKeySelector configMapKeyRef){
            _visitables.remove(this.configMapKeyRef);
            if (configMapKeyRef!=null){ this.configMapKeyRef= new ConfigMapKeySelectorBuilder(configMapKeyRef); _visitables.add(this.configMapKeyRef);} return (A) this;
    }

    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> withNewConfigMapKeyRef(){
            return new ConfigMapKeyRefNestedImpl();
    }

    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> withNewConfigMapKeyRefLike(ConfigMapKeySelector item){
            return new ConfigMapKeyRefNestedImpl(item);
    }

    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> editConfigMapKeyRef(){
            return withNewConfigMapKeyRefLike(getConfigMapKeyRef());
    }

    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> editOrNewConfigMapKeyRef(){
            return withNewConfigMapKeyRefLike(getConfigMapKeyRef() != null ? getConfigMapKeyRef(): new ConfigMapKeySelectorBuilder().build());
    }

    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> editOrNewConfigMapKeyRefLike(ConfigMapKeySelector item){
            return withNewConfigMapKeyRefLike(getConfigMapKeyRef() != null ? getConfigMapKeyRef(): item);
    }

    public A withNewConfigMapKeyRef(String key,String name){
            return (A)withConfigMapKeyRef(new ConfigMapKeySelector(key, name));
    }

    public ObjectFieldSelector getFieldRef(){
            return this.fieldRef!=null?this.fieldRef.build():null;
    }

    public A withFieldRef(ObjectFieldSelector fieldRef){
            _visitables.remove(this.fieldRef);
            if (fieldRef!=null){ this.fieldRef= new ObjectFieldSelectorBuilder(fieldRef); _visitables.add(this.fieldRef);} return (A) this;
    }

    public EnvVarSourceFluent.FieldRefNested<A> withNewFieldRef(){
            return new FieldRefNestedImpl();
    }

    public EnvVarSourceFluent.FieldRefNested<A> withNewFieldRefLike(ObjectFieldSelector item){
            return new FieldRefNestedImpl(item);
    }

    public EnvVarSourceFluent.FieldRefNested<A> editFieldRef(){
            return withNewFieldRefLike(getFieldRef());
    }

    public EnvVarSourceFluent.FieldRefNested<A> editOrNewFieldRef(){
            return withNewFieldRefLike(getFieldRef() != null ? getFieldRef(): new ObjectFieldSelectorBuilder().build());
    }

    public EnvVarSourceFluent.FieldRefNested<A> editOrNewFieldRefLike(ObjectFieldSelector item){
            return withNewFieldRefLike(getFieldRef() != null ? getFieldRef(): item);
    }

    public A withNewFieldRef(String apiVersion,String fieldPath){
            return (A)withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
    }

    public ResourceFieldSelector getResourceFieldRef(){
            return this.resourceFieldRef!=null?this.resourceFieldRef.build():null;
    }

    public A withResourceFieldRef(ResourceFieldSelector resourceFieldRef){
            _visitables.remove(this.resourceFieldRef);
            if (resourceFieldRef!=null){ this.resourceFieldRef= new ResourceFieldSelectorBuilder(resourceFieldRef); _visitables.add(this.resourceFieldRef);} return (A) this;
    }

    public EnvVarSourceFluent.ResourceFieldRefNested<A> withNewResourceFieldRef(){
            return new ResourceFieldRefNestedImpl();
    }

    public EnvVarSourceFluent.ResourceFieldRefNested<A> withNewResourceFieldRefLike(ResourceFieldSelector item){
            return new ResourceFieldRefNestedImpl(item);
    }

    public EnvVarSourceFluent.ResourceFieldRefNested<A> editResourceFieldRef(){
            return withNewResourceFieldRefLike(getResourceFieldRef());
    }

    public EnvVarSourceFluent.ResourceFieldRefNested<A> editOrNewResourceFieldRef(){
            return withNewResourceFieldRefLike(getResourceFieldRef() != null ? getResourceFieldRef(): new ResourceFieldSelectorBuilder().build());
    }

    public EnvVarSourceFluent.ResourceFieldRefNested<A> editOrNewResourceFieldRefLike(ResourceFieldSelector item){
            return withNewResourceFieldRefLike(getResourceFieldRef() != null ? getResourceFieldRef(): item);
    }

    public SecretKeySelector getSecretKeyRef(){
            return this.secretKeyRef!=null?this.secretKeyRef.build():null;
    }

    public A withSecretKeyRef(SecretKeySelector secretKeyRef){
            _visitables.remove(this.secretKeyRef);
            if (secretKeyRef!=null){ this.secretKeyRef= new SecretKeySelectorBuilder(secretKeyRef); _visitables.add(this.secretKeyRef);} return (A) this;
    }

    public EnvVarSourceFluent.SecretKeyRefNested<A> withNewSecretKeyRef(){
            return new SecretKeyRefNestedImpl();
    }

    public EnvVarSourceFluent.SecretKeyRefNested<A> withNewSecretKeyRefLike(SecretKeySelector item){
            return new SecretKeyRefNestedImpl(item);
    }

    public EnvVarSourceFluent.SecretKeyRefNested<A> editSecretKeyRef(){
            return withNewSecretKeyRefLike(getSecretKeyRef());
    }

    public EnvVarSourceFluent.SecretKeyRefNested<A> editOrNewSecretKeyRef(){
            return withNewSecretKeyRefLike(getSecretKeyRef() != null ? getSecretKeyRef(): new SecretKeySelectorBuilder().build());
    }

    public EnvVarSourceFluent.SecretKeyRefNested<A> editOrNewSecretKeyRefLike(SecretKeySelector item){
            return withNewSecretKeyRefLike(getSecretKeyRef() != null ? getSecretKeyRef(): item);
    }

    public A withNewSecretKeyRef(String key,String name){
            return (A)withSecretKeyRef(new SecretKeySelector(key, name));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EnvVarSourceFluentImpl that = (EnvVarSourceFluentImpl) o;
            if (configMapKeyRef != null ? !configMapKeyRef.equals(that.configMapKeyRef) :that.configMapKeyRef != null) return false;
            if (fieldRef != null ? !fieldRef.equals(that.fieldRef) :that.fieldRef != null) return false;
            if (resourceFieldRef != null ? !resourceFieldRef.equals(that.resourceFieldRef) :that.resourceFieldRef != null) return false;
            if (secretKeyRef != null ? !secretKeyRef.equals(that.secretKeyRef) :that.secretKeyRef != null) return false;
            return true;
    }


    public class ConfigMapKeyRefNestedImpl<N> extends ConfigMapKeySelectorFluentImpl<EnvVarSourceFluent.ConfigMapKeyRefNested<N>> implements EnvVarSourceFluent.ConfigMapKeyRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConfigMapKeySelectorBuilder builder;
    
            ConfigMapKeyRefNestedImpl(ConfigMapKeySelector item){
                    this.builder = new ConfigMapKeySelectorBuilder(this, item);
            }
            ConfigMapKeyRefNestedImpl(){
                    this.builder = new ConfigMapKeySelectorBuilder(this);
            }
    
    public N and(){
            return (N) EnvVarSourceFluentImpl.this.withConfigMapKeyRef(builder.build());
    }
    public N endConfigMapKeyRef(){
            return and();
    }

}
    public class FieldRefNestedImpl<N> extends ObjectFieldSelectorFluentImpl<EnvVarSourceFluent.FieldRefNested<N>> implements EnvVarSourceFluent.FieldRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectFieldSelectorBuilder builder;
    
            FieldRefNestedImpl(ObjectFieldSelector item){
                    this.builder = new ObjectFieldSelectorBuilder(this, item);
            }
            FieldRefNestedImpl(){
                    this.builder = new ObjectFieldSelectorBuilder(this);
            }
    
    public N and(){
            return (N) EnvVarSourceFluentImpl.this.withFieldRef(builder.build());
    }
    public N endFieldRef(){
            return and();
    }

}
    public class ResourceFieldRefNestedImpl<N> extends ResourceFieldSelectorFluentImpl<EnvVarSourceFluent.ResourceFieldRefNested<N>> implements EnvVarSourceFluent.ResourceFieldRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceFieldSelectorBuilder builder;
    
            ResourceFieldRefNestedImpl(ResourceFieldSelector item){
                    this.builder = new ResourceFieldSelectorBuilder(this, item);
            }
            ResourceFieldRefNestedImpl(){
                    this.builder = new ResourceFieldSelectorBuilder(this);
            }
    
    public N and(){
            return (N) EnvVarSourceFluentImpl.this.withResourceFieldRef(builder.build());
    }
    public N endResourceFieldRef(){
            return and();
    }

}
    public class SecretKeyRefNestedImpl<N> extends SecretKeySelectorFluentImpl<EnvVarSourceFluent.SecretKeyRefNested<N>> implements EnvVarSourceFluent.SecretKeyRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecretKeySelectorBuilder builder;
    
            SecretKeyRefNestedImpl(SecretKeySelector item){
                    this.builder = new SecretKeySelectorBuilder(this, item);
            }
            SecretKeyRefNestedImpl(){
                    this.builder = new SecretKeySelectorBuilder(this);
            }
    
    public N and(){
            return (N) EnvVarSourceFluentImpl.this.withSecretKeyRef(builder.build());
    }
    public N endSecretKeyRef(){
            return and();
    }

}


}
