package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface EventListFluent<A extends EventListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Event... items);
    public A removeFromItems(Event... items);
    public List<Event> getItems();
    public A withItems(List<Event> items);
    public A withItems(Event... items);
    public EventListFluent.ItemsNested<A> addNewItem();
    public EventListFluent.ItemsNested<A> addNewItemLike(Event item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public EventListFluent.MetadataNested<A> withNewMetadata();
    public EventListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public EventListFluent.MetadataNested<A> editMetadata();
    public EventListFluent.MetadataNested<A> editOrNewMetadata();
    public EventListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EventFluent<EventListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<EventListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
