package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class FCVolumeSourceFluentImpl<A extends FCVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FCVolumeSourceFluent<A>{

    private String fsType;
    private Integer lun;
    private Boolean readOnly;
    private List<String> targetWWNs = new ArrayList<String>();

    public FCVolumeSourceFluentImpl(){
    }
    public FCVolumeSourceFluentImpl(FCVolumeSource instance){
            this.withFsType(instance.getFsType()); 
            this.withLun(instance.getLun()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.withTargetWWNs(instance.getTargetWWNs()); 
    }

    public String getFsType(){
            return this.fsType;
    }

    public A withFsType(String fsType){
            this.fsType=fsType; return (A) this;
    }

    public Integer getLun(){
            return this.lun;
    }

    public A withLun(Integer lun){
            this.lun=lun; return (A) this;
    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public A addToTargetWWNs(String... items){
            for (String item : items) {this.targetWWNs.add(item);} return (A)this;
    }

    public A removeFromTargetWWNs(String... items){
            for (String item : items) {this.targetWWNs.remove(item);} return (A)this;
    }

    public List<String> getTargetWWNs(){
            return this.targetWWNs;
    }

    public A withTargetWWNs(List<String> targetWWNs){
            this.targetWWNs.clear();
            if (targetWWNs != null) {for (String item : targetWWNs){this.addToTargetWWNs(item);}} return (A) this;
    }

    public A withTargetWWNs(String... targetWWNs){
            this.targetWWNs.clear(); if (targetWWNs != null) {for (String item :targetWWNs){ this.addToTargetWWNs(item);}} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FCVolumeSourceFluentImpl that = (FCVolumeSourceFluentImpl) o;
            if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
            if (lun != null ? !lun.equals(that.lun) :that.lun != null) return false;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (targetWWNs != null ? !targetWWNs.equals(that.targetWWNs) :that.targetWWNs != null) return false;
            return true;
    }




}
