package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class HTTPHeaderBuilder extends HTTPHeaderFluentImpl<HTTPHeaderBuilder> implements VisitableBuilder<HTTPHeader,HTTPHeaderBuilder>{

    HTTPHeaderFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPHeaderBuilder(){
            this(true);
    }
    public HTTPHeaderBuilder(Boolean validationEnabled){
            this(new HTTPHeader(), validationEnabled);
    }
    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent){
            this(fluent, true);
    }
    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HTTPHeader(), validationEnabled);
    }
    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent,HTTPHeader instance){
            this(fluent, instance, true);
    }
    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent,HTTPHeader instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPHeaderBuilder(HTTPHeader instance){
            this(instance,true);
    }
    public HTTPHeaderBuilder(HTTPHeader instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public HTTPHeader build(){
            HTTPHeader buildable = new HTTPHeader(fluent.getName(),fluent.getValue());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPHeaderBuilder that = (HTTPHeaderBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
