package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;

public class LimitRangeFluentImpl<A extends LimitRangeFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LimitRangeFluent<A>{

    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private VisitableBuilder<? extends LimitRangeSpec,?> spec;

    public LimitRangeFluentImpl(){
    }
    public LimitRangeFluentImpl(LimitRange instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public LimitRangeFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public LimitRangeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public LimitRangeFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public LimitRangeFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public LimitRangeFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public LimitRangeSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(LimitRangeSpec spec){
            _visitables.remove(this.spec);
            if (spec!=null){ this.spec= new LimitRangeSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public LimitRangeFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public LimitRangeFluent.SpecNested<A> withNewSpecLike(LimitRangeSpec item){
            return new SpecNestedImpl(item);
    }

    public LimitRangeFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public LimitRangeFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new LimitRangeSpecBuilder().build());
    }

    public LimitRangeFluent.SpecNested<A> editOrNewSpecLike(LimitRangeSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LimitRangeFluentImpl that = (LimitRangeFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<LimitRangeFluent.MetadataNested<N>> implements LimitRangeFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) LimitRangeFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends LimitRangeSpecFluentImpl<LimitRangeFluent.SpecNested<N>> implements LimitRangeFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LimitRangeSpecBuilder builder;
    
            SpecNestedImpl(LimitRangeSpec item){
                    this.builder = new LimitRangeSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new LimitRangeSpecBuilder(this);
            }
    
    public N and(){
            return (N) LimitRangeFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}


}
