package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class LimitRangeSpecBuilder extends LimitRangeSpecFluentImpl<LimitRangeSpecBuilder> implements VisitableBuilder<LimitRangeSpec,LimitRangeSpecBuilder>{

    LimitRangeSpecFluent<?> fluent;
    Boolean validationEnabled;

    public LimitRangeSpecBuilder(){
            this(true);
    }
    public LimitRangeSpecBuilder(Boolean validationEnabled){
            this(new LimitRangeSpec(), validationEnabled);
    }
    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent){
            this(fluent, true);
    }
    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LimitRangeSpec(), validationEnabled);
    }
    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent,LimitRangeSpec instance){
            this(fluent, instance, true);
    }
    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent,LimitRangeSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLimits(instance.getLimits()); 
            this.validationEnabled = validationEnabled; 
    }
    public LimitRangeSpecBuilder(LimitRangeSpec instance){
            this(instance,true);
    }
    public LimitRangeSpecBuilder(LimitRangeSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLimits(instance.getLimits()); 
            this.validationEnabled = validationEnabled; 
    }

    public LimitRangeSpec build(){
            LimitRangeSpec buildable = new LimitRangeSpec(fluent.getLimits());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LimitRangeSpecBuilder that = (LimitRangeSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
