package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface PodTemplateSpecFluent<A extends PodTemplateSpecFluent<A>> extends Fluent<A>{


    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public PodTemplateSpecFluent.MetadataNested<A> withNewMetadata();
    public PodTemplateSpecFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PodTemplateSpecFluent.MetadataNested<A> editMetadata();
    public PodTemplateSpecFluent.MetadataNested<A> editOrNewMetadata();
    public PodTemplateSpecFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public PodSpec getSpec();
    public A withSpec(PodSpec spec);
    public PodTemplateSpecFluent.SpecNested<A> withNewSpec();
    public PodTemplateSpecFluent.SpecNested<A> withNewSpecLike(PodSpec item);
    public PodTemplateSpecFluent.SpecNested<A> editSpec();
    public PodTemplateSpecFluent.SpecNested<A> editOrNewSpec();
    public PodTemplateSpecFluent.SpecNested<A> editOrNewSpecLike(PodSpec item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PodTemplateSpecFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodSpecFluent<PodTemplateSpecFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
