package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class ReplicationControllerStatusFluentImpl<A extends ReplicationControllerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ReplicationControllerStatusFluent<A>{

    private Integer fullyLabeledReplicas;
    private Long observedGeneration;
    private Integer replicas;

    public ReplicationControllerStatusFluentImpl(){
    }
    public ReplicationControllerStatusFluentImpl(ReplicationControllerStatus instance){
            this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReplicas(instance.getReplicas()); 
    }

    public Integer getFullyLabeledReplicas(){
            return this.fullyLabeledReplicas;
    }

    public A withFullyLabeledReplicas(Integer fullyLabeledReplicas){
            this.fullyLabeledReplicas=fullyLabeledReplicas; return (A) this;
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReplicationControllerStatusFluentImpl that = (ReplicationControllerStatusFluentImpl) o;
            if (fullyLabeledReplicas != null ? !fullyLabeledReplicas.equals(that.fullyLabeledReplicas) :that.fullyLabeledReplicas != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            return true;
    }




}
