package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class SecretVolumeSourceFluentImpl<A extends SecretVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SecretVolumeSourceFluent<A>{

    private List<VisitableBuilder<? extends KeyToPath,?>> items =  new ArrayList<VisitableBuilder<? extends KeyToPath,?>>();
    private String secretName;

    public SecretVolumeSourceFluentImpl(){
    }
    public SecretVolumeSourceFluentImpl(SecretVolumeSource instance){
            this.withItems(instance.getItems()); 
            this.withSecretName(instance.getSecretName()); 
    }

    public A addToItems(KeyToPath... items){
            for (KeyToPath item : items) {KeyToPathBuilder builder = new KeyToPathBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(KeyToPath... items){
            for (KeyToPath item : items) {KeyToPathBuilder builder = new KeyToPathBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<KeyToPath> getItems(){
            return build(items);
    }

    public A withItems(List<KeyToPath> items){
            _visitables.removeAll(this.items);
            this.items.clear();
            if (items != null) {for (KeyToPath item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(KeyToPath... items){
            this.items.clear(); if (items != null) {for (KeyToPath item :items){ this.addToItems(item);}} return (A) this;
    }

    public SecretVolumeSourceFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public SecretVolumeSourceFluent.ItemsNested<A> addNewItemLike(KeyToPath item){
            return new ItemsNestedImpl(item);
    }

    public A addNewItem(String key,String path){
            return (A)addToItems(new KeyToPath(key, path));
    }

    public String getSecretName(){
            return this.secretName;
    }

    public A withSecretName(String secretName){
            this.secretName=secretName; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SecretVolumeSourceFluentImpl that = (SecretVolumeSourceFluentImpl) o;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends KeyToPathFluentImpl<SecretVolumeSourceFluent.ItemsNested<N>> implements SecretVolumeSourceFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KeyToPathBuilder builder;
    
            ItemsNestedImpl(KeyToPath item){
                    this.builder = new KeyToPathBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.builder = new KeyToPathBuilder(this);
            }
    
    public N and(){
            return (N) SecretVolumeSourceFluentImpl.this.addToItems(builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
