package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;

public class SecurityContextFluentImpl<A extends SecurityContextFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SecurityContextFluent<A>{

    private VisitableBuilder<? extends Capabilities,?> capabilities;
    private Boolean privileged;
    private Boolean readOnlyRootFilesystem;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private VisitableBuilder<? extends SELinuxOptions,?> seLinuxOptions;

    public SecurityContextFluentImpl(){
    }
    public SecurityContextFluentImpl(SecurityContext instance){
            this.withCapabilities(instance.getCapabilities()); 
            this.withPrivileged(instance.getPrivileged()); 
            this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
            this.withRunAsNonRoot(instance.getRunAsNonRoot()); 
            this.withRunAsUser(instance.getRunAsUser()); 
            this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
    }

    public Capabilities getCapabilities(){
            return this.capabilities!=null?this.capabilities.build():null;
    }

    public A withCapabilities(Capabilities capabilities){
            _visitables.remove(this.capabilities);
            if (capabilities!=null){ this.capabilities= new CapabilitiesBuilder(capabilities); _visitables.add(this.capabilities);} return (A) this;
    }

    public SecurityContextFluent.CapabilitiesNested<A> withNewCapabilities(){
            return new CapabilitiesNestedImpl();
    }

    public SecurityContextFluent.CapabilitiesNested<A> withNewCapabilitiesLike(Capabilities item){
            return new CapabilitiesNestedImpl(item);
    }

    public SecurityContextFluent.CapabilitiesNested<A> editCapabilities(){
            return withNewCapabilitiesLike(getCapabilities());
    }

    public SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilities(){
            return withNewCapabilitiesLike(getCapabilities() != null ? getCapabilities(): new CapabilitiesBuilder().build());
    }

    public SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilitiesLike(Capabilities item){
            return withNewCapabilitiesLike(getCapabilities() != null ? getCapabilities(): item);
    }

    public Boolean isPrivileged(){
            return this.privileged;
    }

    public A withPrivileged(Boolean privileged){
            this.privileged=privileged; return (A) this;
    }

    public Boolean isReadOnlyRootFilesystem(){
            return this.readOnlyRootFilesystem;
    }

    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem){
            this.readOnlyRootFilesystem=readOnlyRootFilesystem; return (A) this;
    }

    public Boolean isRunAsNonRoot(){
            return this.runAsNonRoot;
    }

    public A withRunAsNonRoot(Boolean runAsNonRoot){
            this.runAsNonRoot=runAsNonRoot; return (A) this;
    }

    public Long getRunAsUser(){
            return this.runAsUser;
    }

    public A withRunAsUser(Long runAsUser){
            this.runAsUser=runAsUser; return (A) this;
    }

    public SELinuxOptions getSeLinuxOptions(){
            return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }

    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions){
            _visitables.remove(this.seLinuxOptions);
            if (seLinuxOptions!=null){ this.seLinuxOptions= new SELinuxOptionsBuilder(seLinuxOptions); _visitables.add(this.seLinuxOptions);} return (A) this;
    }

    public SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions(){
            return new SeLinuxOptionsNestedImpl();
    }

    public SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item){
            return new SeLinuxOptionsNestedImpl(item);
    }

    public SecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions(){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions());
    }

    public SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions(){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): new SELinuxOptionsBuilder().build());
    }

    public SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): item);
    }

    public A withNewSeLinuxOptions(String level,String role,String type,String user){
            return (A)withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SecurityContextFluentImpl that = (SecurityContextFluentImpl) o;
            if (capabilities != null ? !capabilities.equals(that.capabilities) :that.capabilities != null) return false;
            if (privileged != null ? !privileged.equals(that.privileged) :that.privileged != null) return false;
            if (readOnlyRootFilesystem != null ? !readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) :that.readOnlyRootFilesystem != null) return false;
            if (runAsNonRoot != null ? !runAsNonRoot.equals(that.runAsNonRoot) :that.runAsNonRoot != null) return false;
            if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
            if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
            return true;
    }


    public class CapabilitiesNestedImpl<N> extends CapabilitiesFluentImpl<SecurityContextFluent.CapabilitiesNested<N>> implements SecurityContextFluent.CapabilitiesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CapabilitiesBuilder builder;
    
            CapabilitiesNestedImpl(Capabilities item){
                    this.builder = new CapabilitiesBuilder(this, item);
            }
            CapabilitiesNestedImpl(){
                    this.builder = new CapabilitiesBuilder(this);
            }
    
    public N and(){
            return (N) SecurityContextFluentImpl.this.withCapabilities(builder.build());
    }
    public N endCapabilities(){
            return and();
    }

}
    public class SeLinuxOptionsNestedImpl<N> extends SELinuxOptionsFluentImpl<SecurityContextFluent.SeLinuxOptionsNested<N>> implements SecurityContextFluent.SeLinuxOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SELinuxOptionsBuilder builder;
    
            SeLinuxOptionsNestedImpl(SELinuxOptions item){
                    this.builder = new SELinuxOptionsBuilder(this, item);
            }
            SeLinuxOptionsNestedImpl(){
                    this.builder = new SELinuxOptionsBuilder(this);
            }
    
    public N and(){
            return (N) SecurityContextFluentImpl.this.withSeLinuxOptions(builder.build());
    }
    public N endSeLinuxOptions(){
            return and();
    }

}


}
