package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ServiceFluent<A extends ServiceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ServiceFluent.MetadataNested<A> withNewMetadata();
    public ServiceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ServiceFluent.MetadataNested<A> editMetadata();
    public ServiceFluent.MetadataNested<A> editOrNewMetadata();
    public ServiceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public ServiceSpec getSpec();
    public A withSpec(ServiceSpec spec);
    public ServiceFluent.SpecNested<A> withNewSpec();
    public ServiceFluent.SpecNested<A> withNewSpecLike(ServiceSpec item);
    public ServiceFluent.SpecNested<A> editSpec();
    public ServiceFluent.SpecNested<A> editOrNewSpec();
    public ServiceFluent.SpecNested<A> editOrNewSpecLike(ServiceSpec item);
    public ServiceStatus getStatus();
    public A withStatus(ServiceStatus status);
    public ServiceFluent.StatusNested<A> withNewStatus();
    public ServiceFluent.StatusNested<A> withNewStatusLike(ServiceStatus item);
    public ServiceFluent.StatusNested<A> editStatus();
    public ServiceFluent.StatusNested<A> editOrNewStatus();
    public ServiceFluent.StatusNested<A> editOrNewStatusLike(ServiceStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ServiceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceSpecFluent<ServiceFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceStatusFluent<ServiceFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
