package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ServiceListFluent<A extends ServiceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Service... items);
    public A removeFromItems(Service... items);
    public List<Service> getItems();
    public A withItems(List<Service> items);
    public A withItems(Service... items);
    public ServiceListFluent.ItemsNested<A> addNewItem();
    public ServiceListFluent.ItemsNested<A> addNewItemLike(Service item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ServiceListFluent.MetadataNested<A> withNewMetadata();
    public ServiceListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ServiceListFluent.MetadataNested<A> editMetadata();
    public ServiceListFluent.MetadataNested<A> editOrNewMetadata();
    public ServiceListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceFluent<ServiceListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<ServiceListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
