package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public class ServiceSpecFluentImpl<A extends ServiceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServiceSpecFluent<A>{

    private String clusterIP;
    private List<String> deprecatedPublicIPs = new ArrayList<String>();
    private List<String> externalIPs = new ArrayList<String>();
    private String loadBalancerIP;
    private List<String> loadBalancerSourceRanges = new ArrayList<String>();
    private String portalIP;
    private List<VisitableBuilder<? extends ServicePort,?>> ports =  new ArrayList<VisitableBuilder<? extends ServicePort,?>>();
    private Map<String,String> selector = new LinkedHashMap<String,String>();
    private String sessionAffinity;
    private String type;

    public ServiceSpecFluentImpl(){
    }
    public ServiceSpecFluentImpl(ServiceSpec instance){
            this.withClusterIP(instance.getClusterIP()); 
            this.withDeprecatedPublicIPs(instance.getDeprecatedPublicIPs()); 
            this.withExternalIPs(instance.getExternalIPs()); 
            this.withLoadBalancerIP(instance.getLoadBalancerIP()); 
            this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges()); 
            this.withPortalIP(instance.getPortalIP()); 
            this.withPorts(instance.getPorts()); 
            this.withSelector(instance.getSelector()); 
            this.withSessionAffinity(instance.getSessionAffinity()); 
            this.withType(instance.getType()); 
    }

    public String getClusterIP(){
            return this.clusterIP;
    }

    public A withClusterIP(String clusterIP){
            this.clusterIP=clusterIP; return (A) this;
    }

    public A addToDeprecatedPublicIPs(String... items){
            for (String item : items) {this.deprecatedPublicIPs.add(item);} return (A)this;
    }

    public A removeFromDeprecatedPublicIPs(String... items){
            for (String item : items) {this.deprecatedPublicIPs.remove(item);} return (A)this;
    }

    public List<String> getDeprecatedPublicIPs(){
            return this.deprecatedPublicIPs;
    }

    public A withDeprecatedPublicIPs(List<String> deprecatedPublicIPs){
            this.deprecatedPublicIPs.clear();
            if (deprecatedPublicIPs != null) {for (String item : deprecatedPublicIPs){this.addToDeprecatedPublicIPs(item);}} return (A) this;
    }

    public A withDeprecatedPublicIPs(String... deprecatedPublicIPs){
            this.deprecatedPublicIPs.clear(); if (deprecatedPublicIPs != null) {for (String item :deprecatedPublicIPs){ this.addToDeprecatedPublicIPs(item);}} return (A) this;
    }

    public A addToExternalIPs(String... items){
            for (String item : items) {this.externalIPs.add(item);} return (A)this;
    }

    public A removeFromExternalIPs(String... items){
            for (String item : items) {this.externalIPs.remove(item);} return (A)this;
    }

    public List<String> getExternalIPs(){
            return this.externalIPs;
    }

    public A withExternalIPs(List<String> externalIPs){
            this.externalIPs.clear();
            if (externalIPs != null) {for (String item : externalIPs){this.addToExternalIPs(item);}} return (A) this;
    }

    public A withExternalIPs(String... externalIPs){
            this.externalIPs.clear(); if (externalIPs != null) {for (String item :externalIPs){ this.addToExternalIPs(item);}} return (A) this;
    }

    public String getLoadBalancerIP(){
            return this.loadBalancerIP;
    }

    public A withLoadBalancerIP(String loadBalancerIP){
            this.loadBalancerIP=loadBalancerIP; return (A) this;
    }

    public A addToLoadBalancerSourceRanges(String... items){
            for (String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
    }

    public A removeFromLoadBalancerSourceRanges(String... items){
            for (String item : items) {this.loadBalancerSourceRanges.remove(item);} return (A)this;
    }

    public List<String> getLoadBalancerSourceRanges(){
            return this.loadBalancerSourceRanges;
    }

    public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges){
            this.loadBalancerSourceRanges.clear();
            if (loadBalancerSourceRanges != null) {for (String item : loadBalancerSourceRanges){this.addToLoadBalancerSourceRanges(item);}} return (A) this;
    }

    public A withLoadBalancerSourceRanges(String... loadBalancerSourceRanges){
            this.loadBalancerSourceRanges.clear(); if (loadBalancerSourceRanges != null) {for (String item :loadBalancerSourceRanges){ this.addToLoadBalancerSourceRanges(item);}} return (A) this;
    }

    public String getPortalIP(){
            return this.portalIP;
    }

    public A withPortalIP(String portalIP){
            this.portalIP=portalIP; return (A) this;
    }

    public A addToPorts(ServicePort... items){
            for (ServicePort item : items) {ServicePortBuilder builder = new ServicePortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(ServicePort... items){
            for (ServicePort item : items) {ServicePortBuilder builder = new ServicePortBuilder(item);_visitables.remove(builder);this.ports.remove(builder);} return (A)this;
    }

    public List<ServicePort> getPorts(){
            return build(ports);
    }

    public A withPorts(List<ServicePort> ports){
            _visitables.removeAll(this.ports);
            this.ports.clear();
            if (ports != null) {for (ServicePort item : ports){this.addToPorts(item);}} return (A) this;
    }

    public A withPorts(ServicePort... ports){
            this.ports.clear(); if (ports != null) {for (ServicePort item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public ServiceSpecFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public ServiceSpecFluent.PortsNested<A> addNewPortLike(ServicePort item){
            return new PortsNestedImpl(item);
    }

    public A addToSelector(String key,String value){
            if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
    }

    public A addToSelector(Map<String,String> map){
            if(map != null) { this.selector.putAll(map);} return (A)this;
    }

    public A removeFromSelector(String key){
            if(key != null) {this.selector.remove(key);} return (A)this;
    }

    public A removeFromSelector(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.selector.remove(key);}} return (A)this;
    }

    public Map<String,String> getSelector(){
            return this.selector;
    }

    public A withSelector(Map<String,String> selector){
            this.selector.clear();
            if (selector != null) {this.selector.putAll(selector);} return (A) this;
    }

    public String getSessionAffinity(){
            return this.sessionAffinity;
    }

    public A withSessionAffinity(String sessionAffinity){
            this.sessionAffinity=sessionAffinity; return (A) this;
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceSpecFluentImpl that = (ServiceSpecFluentImpl) o;
            if (clusterIP != null ? !clusterIP.equals(that.clusterIP) :that.clusterIP != null) return false;
            if (deprecatedPublicIPs != null ? !deprecatedPublicIPs.equals(that.deprecatedPublicIPs) :that.deprecatedPublicIPs != null) return false;
            if (externalIPs != null ? !externalIPs.equals(that.externalIPs) :that.externalIPs != null) return false;
            if (loadBalancerIP != null ? !loadBalancerIP.equals(that.loadBalancerIP) :that.loadBalancerIP != null) return false;
            if (loadBalancerSourceRanges != null ? !loadBalancerSourceRanges.equals(that.loadBalancerSourceRanges) :that.loadBalancerSourceRanges != null) return false;
            if (portalIP != null ? !portalIP.equals(that.portalIP) :that.portalIP != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (sessionAffinity != null ? !sessionAffinity.equals(that.sessionAffinity) :that.sessionAffinity != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class PortsNestedImpl<N> extends ServicePortFluentImpl<ServiceSpecFluent.PortsNested<N>> implements ServiceSpecFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServicePortBuilder builder;
    
            PortsNestedImpl(ServicePort item){
                    this.builder = new ServicePortBuilder(this, item);
            }
            PortsNestedImpl(){
                    this.builder = new ServicePortBuilder(this);
            }
    
    public N and(){
            return (N) ServiceSpecFluentImpl.this.addToPorts(builder.build());
    }
    public N endPort(){
            return and();
    }

}


}
