package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;

public class SupplementalGroupsStrategyOptionsFluentImpl<A extends SupplementalGroupsStrategyOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SupplementalGroupsStrategyOptionsFluent<A>{

    private List<VisitableBuilder<? extends IDRange,?>> ranges =  new ArrayList<VisitableBuilder<? extends IDRange,?>>();
    private String type;

    public SupplementalGroupsStrategyOptionsFluentImpl(){
    }
    public SupplementalGroupsStrategyOptionsFluentImpl(SupplementalGroupsStrategyOptions instance){
            this.withRanges(instance.getRanges()); 
            this.withType(instance.getType()); 
    }

    public A addToRanges(IDRange... items){
            for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.add(builder);this.ranges.add(builder);} return (A)this;
    }

    public A removeFromRanges(IDRange... items){
            for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.remove(builder);this.ranges.remove(builder);} return (A)this;
    }

    public List<IDRange> getRanges(){
            return build(ranges);
    }

    public A withRanges(List<IDRange> ranges){
            _visitables.removeAll(this.ranges);
            this.ranges.clear();
            if (ranges != null) {for (IDRange item : ranges){this.addToRanges(item);}} return (A) this;
    }

    public A withRanges(IDRange... ranges){
            this.ranges.clear(); if (ranges != null) {for (IDRange item :ranges){ this.addToRanges(item);}} return (A) this;
    }

    public SupplementalGroupsStrategyOptionsFluent.RangesNested<A> addNewRange(){
            return new RangesNestedImpl();
    }

    public SupplementalGroupsStrategyOptionsFluent.RangesNested<A> addNewRangeLike(IDRange item){
            return new RangesNestedImpl(item);
    }

    public A addNewRange(Long max,Long min){
            return (A)addToRanges(new IDRange(max, min));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SupplementalGroupsStrategyOptionsFluentImpl that = (SupplementalGroupsStrategyOptionsFluentImpl) o;
            if (ranges != null ? !ranges.equals(that.ranges) :that.ranges != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class RangesNestedImpl<N> extends IDRangeFluentImpl<SupplementalGroupsStrategyOptionsFluent.RangesNested<N>> implements SupplementalGroupsStrategyOptionsFluent.RangesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IDRangeBuilder builder;
    
            RangesNestedImpl(IDRange item){
                    this.builder = new IDRangeBuilder(this, item);
            }
            RangesNestedImpl(){
                    this.builder = new IDRangeBuilder(this);
            }
    
    public N and(){
            return (N) SupplementalGroupsStrategyOptionsFluentImpl.this.addToRanges(builder.build());
    }
    public N endRange(){
            return and();
    }

}


}
