package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class APIVersionBuilder extends APIVersionFluentImpl<APIVersionBuilder> implements VisitableBuilder<APIVersion,APIVersionBuilder>{

    APIVersionFluent<?> fluent;
    Boolean validationEnabled;

    public APIVersionBuilder(){
            this(true);
    }
    public APIVersionBuilder(Boolean validationEnabled){
            this(new APIVersion(), validationEnabled);
    }
    public APIVersionBuilder(APIVersionFluent<?> fluent){
            this(fluent, true);
    }
    public APIVersionBuilder(APIVersionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new APIVersion(), validationEnabled);
    }
    public APIVersionBuilder(APIVersionFluent<?> fluent,APIVersion instance){
            this(fluent, instance, true);
    }
    public APIVersionBuilder(APIVersionFluent<?> fluent,APIVersion instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public APIVersionBuilder(APIVersion instance){
            this(instance,true);
    }
    public APIVersionBuilder(APIVersion instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public APIVersion build(){
            APIVersion buildable = new APIVersion(fluent.getName());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            APIVersionBuilder that = (APIVersionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
