package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class DaemonSetSpecBuilder extends DaemonSetSpecFluentImpl<DaemonSetSpecBuilder> implements VisitableBuilder<DaemonSetSpec,DaemonSetSpecBuilder>{

    DaemonSetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public DaemonSetSpecBuilder(){
            this(true);
    }
    public DaemonSetSpecBuilder(Boolean validationEnabled){
            this(new DaemonSetSpec(), validationEnabled);
    }
    public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent){
            this(fluent, true);
    }
    public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DaemonSetSpec(), validationEnabled);
    }
    public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent,DaemonSetSpec instance){
            this(fluent, instance, true);
    }
    public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent,DaemonSetSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSelector(instance.getSelector()); 
            fluent.withTemplate(instance.getTemplate()); 
            this.validationEnabled = validationEnabled; 
    }
    public DaemonSetSpecBuilder(DaemonSetSpec instance){
            this(instance,true);
    }
    public DaemonSetSpecBuilder(DaemonSetSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSelector(instance.getSelector()); 
            this.withTemplate(instance.getTemplate()); 
            this.validationEnabled = validationEnabled; 
    }

    public DaemonSetSpec build(){
            DaemonSetSpec buildable = new DaemonSetSpec(fluent.getSelector(),fluent.getTemplate());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DaemonSetSpecBuilder that = (DaemonSetSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
