package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface IngressSpecFluent<A extends IngressSpecFluent<A>> extends Fluent<A>{


    public IngressBackend getBackend();
    public A withBackend(IngressBackend backend);
    public IngressSpecFluent.BackendNested<A> withNewBackend();
    public IngressSpecFluent.BackendNested<A> withNewBackendLike(IngressBackend item);
    public IngressSpecFluent.BackendNested<A> editBackend();
    public IngressSpecFluent.BackendNested<A> editOrNewBackend();
    public IngressSpecFluent.BackendNested<A> editOrNewBackendLike(IngressBackend item);
    public A addToRules(IngressRule... items);
    public A removeFromRules(IngressRule... items);
    public List<IngressRule> getRules();
    public A withRules(List<IngressRule> rules);
    public A withRules(IngressRule... rules);
    public IngressSpecFluent.RulesNested<A> addNewRule();
    public IngressSpecFluent.RulesNested<A> addNewRuleLike(IngressRule item);
    public A addToTls(IngressTLS... items);
    public A removeFromTls(IngressTLS... items);
    public List<IngressTLS> getTls();
    public A withTls(List<IngressTLS> tls);
    public A withTls(IngressTLS... tls);
    public IngressSpecFluent.TlsNested<A> addNewTl();
    public IngressSpecFluent.TlsNested<A> addNewTlLike(IngressTLS item);

    public interface BackendNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressBackendFluent<IngressSpecFluent.BackendNested<N>>{

        
    public N and();    public N endBackend();
}
    public interface RulesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressRuleFluent<IngressSpecFluent.RulesNested<N>>{

        
    public N and();    public N endRule();
}
    public interface TlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressTLSFluent<IngressSpecFluent.TlsNested<N>>{

        
    public N and();    public N endTl();
}


}
