package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;

public class JobStatusFluentImpl<A extends JobStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JobStatusFluent<A>{

    private Integer active;
    private String completionTime;
    private List<VisitableBuilder<? extends JobCondition,?>> conditions =  new ArrayList<VisitableBuilder<? extends JobCondition,?>>();
    private Integer failed;
    private String startTime;
    private Integer succeeded;

    public JobStatusFluentImpl(){
    }
    public JobStatusFluentImpl(JobStatus instance){
            this.withActive(instance.getActive()); 
            this.withCompletionTime(instance.getCompletionTime()); 
            this.withConditions(instance.getConditions()); 
            this.withFailed(instance.getFailed()); 
            this.withStartTime(instance.getStartTime()); 
            this.withSucceeded(instance.getSucceeded()); 
    }

    public Integer getActive(){
            return this.active;
    }

    public A withActive(Integer active){
            this.active=active; return (A) this;
    }

    public String getCompletionTime(){
            return this.completionTime;
    }

    public A withCompletionTime(String completionTime){
            this.completionTime=completionTime; return (A) this;
    }

    public A addToConditions(JobCondition... items){
            for (JobCondition item : items) {JobConditionBuilder builder = new JobConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(JobCondition... items){
            for (JobCondition item : items) {JobConditionBuilder builder = new JobConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (A)this;
    }

    public List<JobCondition> getConditions(){
            return build(conditions);
    }

    public A withConditions(List<JobCondition> conditions){
            _visitables.removeAll(this.conditions);
            this.conditions.clear();
            if (conditions != null) {for (JobCondition item : conditions){this.addToConditions(item);}} return (A) this;
    }

    public A withConditions(JobCondition... conditions){
            this.conditions.clear(); if (conditions != null) {for (JobCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public JobStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public JobStatusFluent.ConditionsNested<A> addNewConditionLike(JobCondition item){
            return new ConditionsNestedImpl(item);
    }

    public Integer getFailed(){
            return this.failed;
    }

    public A withFailed(Integer failed){
            this.failed=failed; return (A) this;
    }

    public String getStartTime(){
            return this.startTime;
    }

    public A withStartTime(String startTime){
            this.startTime=startTime; return (A) this;
    }

    public Integer getSucceeded(){
            return this.succeeded;
    }

    public A withSucceeded(Integer succeeded){
            this.succeeded=succeeded; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JobStatusFluentImpl that = (JobStatusFluentImpl) o;
            if (active != null ? !active.equals(that.active) :that.active != null) return false;
            if (completionTime != null ? !completionTime.equals(that.completionTime) :that.completionTime != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (failed != null ? !failed.equals(that.failed) :that.failed != null) return false;
            if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
            if (succeeded != null ? !succeeded.equals(that.succeeded) :that.succeeded != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends JobConditionFluentImpl<JobStatusFluent.ConditionsNested<N>> implements JobStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JobConditionBuilder builder;
    
            ConditionsNestedImpl(JobCondition item){
                    this.builder = new JobConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.builder = new JobConditionBuilder(this);
            }
    
    public N and(){
            return (N) JobStatusFluentImpl.this.addToConditions(builder.build());
    }
    public N endCondition(){
            return and();
    }

}


}
