package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class PetSetListBuilder extends PetSetListFluentImpl<PetSetListBuilder> implements VisitableBuilder<PetSetList,PetSetListBuilder>{

    PetSetListFluent<?> fluent;
    Boolean validationEnabled;

    public PetSetListBuilder(){
            this(true);
    }
    public PetSetListBuilder(Boolean validationEnabled){
            this(new PetSetList(), validationEnabled);
    }
    public PetSetListBuilder(PetSetListFluent<?> fluent){
            this(fluent, true);
    }
    public PetSetListBuilder(PetSetListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PetSetList(), validationEnabled);
    }
    public PetSetListBuilder(PetSetListFluent<?> fluent,PetSetList instance){
            this(fluent, instance, true);
    }
    public PetSetListBuilder(PetSetListFluent<?> fluent,PetSetList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public PetSetListBuilder(PetSetList instance){
            this(instance,true);
    }
    public PetSetListBuilder(PetSetList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public PetSetList build(){
            PetSetList buildable = new PetSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PetSetListBuilder that = (PetSetListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
