package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import lombok.ToString;
import java.util.Map;

public interface PetSetSpecFluent<A extends PetSetSpecFluent<A>> extends Fluent<A>{


    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public LabelSelector getSelector();
    public A withSelector(LabelSelector selector);
    public PetSetSpecFluent.SelectorNested<A> withNewSelector();
    public PetSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public PetSetSpecFluent.SelectorNested<A> editSelector();
    public PetSetSpecFluent.SelectorNested<A> editOrNewSelector();
    public PetSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    public String getServiceName();
    public A withServiceName(String serviceName);
    public PodTemplateSpec getTemplate();
    public A withTemplate(PodTemplateSpec template);
    public PetSetSpecFluent.TemplateNested<A> withNewTemplate();
    public PetSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public PetSetSpecFluent.TemplateNested<A> editTemplate();
    public PetSetSpecFluent.TemplateNested<A> editOrNewTemplate();
    public PetSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);
    public A addToVolumeClaimTemplates(PersistentVolumeClaim... items);
    public A removeFromVolumeClaimTemplates(PersistentVolumeClaim... items);
    public List<PersistentVolumeClaim> getVolumeClaimTemplates();
    public A withVolumeClaimTemplates(List<PersistentVolumeClaim> volumeClaimTemplates);
    public A withVolumeClaimTemplates(PersistentVolumeClaim... volumeClaimTemplates);
    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate();
    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(PersistentVolumeClaim item);

    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PetSetSpecFluent.SelectorNested<N>>{

        
    public N and();    public N endSelector();
}
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<PetSetSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}
    public interface VolumeClaimTemplatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<PetSetSpecFluent.VolumeClaimTemplatesNested<N>>{

        
    public N and();    public N endVolumeClaimTemplate();
}


}
