package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class PetSetStatusBuilder extends PetSetStatusFluentImpl<PetSetStatusBuilder> implements VisitableBuilder<PetSetStatus,PetSetStatusBuilder>{

    PetSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PetSetStatusBuilder(){
            this(true);
    }
    public PetSetStatusBuilder(Boolean validationEnabled){
            this(new PetSetStatus(), validationEnabled);
    }
    public PetSetStatusBuilder(PetSetStatusFluent<?> fluent){
            this(fluent, true);
    }
    public PetSetStatusBuilder(PetSetStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PetSetStatus(), validationEnabled);
    }
    public PetSetStatusBuilder(PetSetStatusFluent<?> fluent,PetSetStatus instance){
            this(fluent, instance, true);
    }
    public PetSetStatusBuilder(PetSetStatusFluent<?> fluent,PetSetStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withReplicas(instance.getReplicas()); 
            this.validationEnabled = validationEnabled; 
    }
    public PetSetStatusBuilder(PetSetStatus instance){
            this(instance,true);
    }
    public PetSetStatusBuilder(PetSetStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReplicas(instance.getReplicas()); 
            this.validationEnabled = validationEnabled; 
    }

    public PetSetStatus build(){
            PetSetStatus buildable = new PetSetStatus(fluent.getObservedGeneration(),fluent.getReplicas());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PetSetStatusBuilder that = (PetSetStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
