package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface BuildConfigFluent<A extends BuildConfigFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public BuildConfigFluent.MetadataNested<A> withNewMetadata();
    public BuildConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public BuildConfigFluent.MetadataNested<A> editMetadata();
    public BuildConfigFluent.MetadataNested<A> editOrNewMetadata();
    public BuildConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public BuildConfigSpec getSpec();
    public A withSpec(BuildConfigSpec spec);
    public BuildConfigFluent.SpecNested<A> withNewSpec();
    public BuildConfigFluent.SpecNested<A> withNewSpecLike(BuildConfigSpec item);
    public BuildConfigFluent.SpecNested<A> editSpec();
    public BuildConfigFluent.SpecNested<A> editOrNewSpec();
    public BuildConfigFluent.SpecNested<A> editOrNewSpecLike(BuildConfigSpec item);
    public BuildConfigStatus getStatus();
    public A withStatus(BuildConfigStatus status);
    public BuildConfigFluent.StatusNested<A> withNewStatus();
    public BuildConfigFluent.StatusNested<A> withNewStatusLike(BuildConfigStatus item);
    public BuildConfigFluent.StatusNested<A> editStatus();
    public BuildConfigFluent.StatusNested<A> editOrNewStatus();
    public BuildConfigFluent.StatusNested<A> editOrNewStatusLike(BuildConfigStatus item);
    public A withNewStatus(Long lastVersion);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<BuildConfigFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildConfigSpecFluent<BuildConfigFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildConfigStatusFluent<BuildConfigFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
