package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class ImageChangeTriggerBuilder extends ImageChangeTriggerFluentImpl<ImageChangeTriggerBuilder> implements VisitableBuilder<ImageChangeTrigger,ImageChangeTriggerBuilder>{

    ImageChangeTriggerFluent<?> fluent;
    Boolean validationEnabled;

    public ImageChangeTriggerBuilder(){
            this(true);
    }
    public ImageChangeTriggerBuilder(Boolean validationEnabled){
            this(new ImageChangeTrigger(), validationEnabled);
    }
    public ImageChangeTriggerBuilder(ImageChangeTriggerFluent<?> fluent){
            this(fluent, true);
    }
    public ImageChangeTriggerBuilder(ImageChangeTriggerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ImageChangeTrigger(), validationEnabled);
    }
    public ImageChangeTriggerBuilder(ImageChangeTriggerFluent<?> fluent,ImageChangeTrigger instance){
            this(fluent, instance, true);
    }
    public ImageChangeTriggerBuilder(ImageChangeTriggerFluent<?> fluent,ImageChangeTrigger instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFrom(instance.getFrom()); 
            fluent.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
            this.validationEnabled = validationEnabled; 
    }
    public ImageChangeTriggerBuilder(ImageChangeTrigger instance){
            this(instance,true);
    }
    public ImageChangeTriggerBuilder(ImageChangeTrigger instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFrom(instance.getFrom()); 
            this.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
            this.validationEnabled = validationEnabled; 
    }

    public ImageChangeTrigger build(){
            ImageChangeTrigger buildable = new ImageChangeTrigger(fluent.getFrom(),fluent.getLastTriggeredImageID());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageChangeTriggerBuilder that = (ImageChangeTriggerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
