package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class ImageChangeTriggerFluentImpl<A extends ImageChangeTriggerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageChangeTriggerFluent<A>{

    private VisitableBuilder<? extends ObjectReference,?> from;
    private String lastTriggeredImageID;

    public ImageChangeTriggerFluentImpl(){
    }
    public ImageChangeTriggerFluentImpl(ImageChangeTrigger instance){
            this.withFrom(instance.getFrom()); 
            this.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
    }

    public ObjectReference getFrom(){
            return this.from!=null?this.from.build():null;
    }

    public A withFrom(ObjectReference from){
            _visitables.remove(this.from);
            if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }

    public ImageChangeTriggerFluent.FromNested<A> withNewFrom(){
            return new FromNestedImpl();
    }

    public ImageChangeTriggerFluent.FromNested<A> withNewFromLike(ObjectReference item){
            return new FromNestedImpl(item);
    }

    public ImageChangeTriggerFluent.FromNested<A> editFrom(){
            return withNewFromLike(getFrom());
    }

    public ImageChangeTriggerFluent.FromNested<A> editOrNewFrom(){
            return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
    }

    public ImageChangeTriggerFluent.FromNested<A> editOrNewFromLike(ObjectReference item){
            return withNewFromLike(getFrom() != null ? getFrom(): item);
    }

    public String getLastTriggeredImageID(){
            return this.lastTriggeredImageID;
    }

    public A withLastTriggeredImageID(String lastTriggeredImageID){
            this.lastTriggeredImageID=lastTriggeredImageID; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageChangeTriggerFluentImpl that = (ImageChangeTriggerFluentImpl) o;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (lastTriggeredImageID != null ? !lastTriggeredImageID.equals(that.lastTriggeredImageID) :that.lastTriggeredImageID != null) return false;
            return true;
    }


    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<ImageChangeTriggerFluent.FromNested<N>> implements ImageChangeTriggerFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            FromNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            FromNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) ImageChangeTriggerFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom(){
            return and();
    }

}


}
