package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ImageStreamFluent<A extends ImageStreamFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ImageStreamFluent.MetadataNested<A> withNewMetadata();
    public ImageStreamFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ImageStreamFluent.MetadataNested<A> editMetadata();
    public ImageStreamFluent.MetadataNested<A> editOrNewMetadata();
    public ImageStreamFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public ImageStreamSpec getSpec();
    public A withSpec(ImageStreamSpec spec);
    public ImageStreamFluent.SpecNested<A> withNewSpec();
    public ImageStreamFluent.SpecNested<A> withNewSpecLike(ImageStreamSpec item);
    public ImageStreamFluent.SpecNested<A> editSpec();
    public ImageStreamFluent.SpecNested<A> editOrNewSpec();
    public ImageStreamFluent.SpecNested<A> editOrNewSpecLike(ImageStreamSpec item);
    public ImageStreamStatus getStatus();
    public A withStatus(ImageStreamStatus status);
    public ImageStreamFluent.StatusNested<A> withNewStatus();
    public ImageStreamFluent.StatusNested<A> withNewStatusLike(ImageStreamStatus item);
    public ImageStreamFluent.StatusNested<A> editStatus();
    public ImageStreamFluent.StatusNested<A> editOrNewStatus();
    public ImageStreamFluent.StatusNested<A> editOrNewStatusLike(ImageStreamStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ImageStreamFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamSpecFluent<ImageStreamFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamStatusFluent<ImageStreamFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
