package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ImageStreamTagFluent<A extends ImageStreamTagFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToConditions(TagEventCondition... items);
    public A removeFromConditions(TagEventCondition... items);
    public List<TagEventCondition> getConditions();
    public A withConditions(List<TagEventCondition> conditions);
    public A withConditions(TagEventCondition... conditions);
    public ImageStreamTagFluent.ConditionsNested<A> addNewCondition();
    public ImageStreamTagFluent.ConditionsNested<A> addNewConditionLike(TagEventCondition item);
    public Long getGeneration();
    public A withGeneration(Long generation);
    public Image getImage();
    public A withImage(Image image);
    public ImageStreamTagFluent.ImageNested<A> withNewImage();
    public ImageStreamTagFluent.ImageNested<A> withNewImageLike(Image item);
    public ImageStreamTagFluent.ImageNested<A> editImage();
    public ImageStreamTagFluent.ImageNested<A> editOrNewImage();
    public ImageStreamTagFluent.ImageNested<A> editOrNewImageLike(Image item);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ImageStreamTagFluent.MetadataNested<A> withNewMetadata();
    public ImageStreamTagFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ImageStreamTagFluent.MetadataNested<A> editMetadata();
    public ImageStreamTagFluent.MetadataNested<A> editOrNewMetadata();
    public ImageStreamTagFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public TagReference getTag();
    public A withTag(TagReference tag);
    public ImageStreamTagFluent.TagNested<A> withNewTag();
    public ImageStreamTagFluent.TagNested<A> withNewTagLike(TagReference item);
    public ImageStreamTagFluent.TagNested<A> editTag();
    public ImageStreamTagFluent.TagNested<A> editOrNewTag();
    public ImageStreamTagFluent.TagNested<A> editOrNewTagLike(TagReference item);

    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TagEventConditionFluent<ImageStreamTagFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}
    public interface ImageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageFluent<ImageStreamTagFluent.ImageNested<N>>{

        
    public N and();    public N endImage();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ImageStreamTagFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface TagNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TagReferenceFluent<ImageStreamTagFluent.TagNested<N>>{

        
    public N and();    public N endTag();
}


}
