package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class OAuthAuthorizeTokenBuilder extends OAuthAuthorizeTokenFluentImpl<OAuthAuthorizeTokenBuilder> implements VisitableBuilder<OAuthAuthorizeToken,OAuthAuthorizeTokenBuilder>{

    OAuthAuthorizeTokenFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthAuthorizeTokenBuilder(){
            this(true);
    }
    public OAuthAuthorizeTokenBuilder(Boolean validationEnabled){
            this(new OAuthAuthorizeToken(), validationEnabled);
    }
    public OAuthAuthorizeTokenBuilder(OAuthAuthorizeTokenFluent<?> fluent){
            this(fluent, true);
    }
    public OAuthAuthorizeTokenBuilder(OAuthAuthorizeTokenFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OAuthAuthorizeToken(), validationEnabled);
    }
    public OAuthAuthorizeTokenBuilder(OAuthAuthorizeTokenFluent<?> fluent,OAuthAuthorizeToken instance){
            this(fluent, instance, true);
    }
    public OAuthAuthorizeTokenBuilder(OAuthAuthorizeTokenFluent<?> fluent,OAuthAuthorizeToken instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withClientName(instance.getClientName()); 
            fluent.withExpiresIn(instance.getExpiresIn()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRedirectURI(instance.getRedirectURI()); 
            fluent.withScopes(instance.getScopes()); 
            fluent.withState(instance.getState()); 
            fluent.withUserName(instance.getUserName()); 
            fluent.withUserUID(instance.getUserUID()); 
            this.validationEnabled = validationEnabled; 
    }
    public OAuthAuthorizeTokenBuilder(OAuthAuthorizeToken instance){
            this(instance,true);
    }
    public OAuthAuthorizeTokenBuilder(OAuthAuthorizeToken instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withClientName(instance.getClientName()); 
            this.withExpiresIn(instance.getExpiresIn()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRedirectURI(instance.getRedirectURI()); 
            this.withScopes(instance.getScopes()); 
            this.withState(instance.getState()); 
            this.withUserName(instance.getUserName()); 
            this.withUserUID(instance.getUserUID()); 
            this.validationEnabled = validationEnabled; 
    }

    public OAuthAuthorizeToken build(){
            OAuthAuthorizeToken buildable = new OAuthAuthorizeToken(fluent.getApiVersion(),fluent.getClientName(),fluent.getExpiresIn(),fluent.getKind(),fluent.getMetadata(),fluent.getRedirectURI(),fluent.getScopes(),fluent.getState(),fluent.getUserName(),fluent.getUserUID());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OAuthAuthorizeTokenBuilder that = (OAuthAuthorizeTokenBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
