package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface RouteFluent<A extends RouteFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public RouteFluent.MetadataNested<A> withNewMetadata();
    public RouteFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public RouteFluent.MetadataNested<A> editMetadata();
    public RouteFluent.MetadataNested<A> editOrNewMetadata();
    public RouteFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public RouteSpec getSpec();
    public A withSpec(RouteSpec spec);
    public RouteFluent.SpecNested<A> withNewSpec();
    public RouteFluent.SpecNested<A> withNewSpecLike(RouteSpec item);
    public RouteFluent.SpecNested<A> editSpec();
    public RouteFluent.SpecNested<A> editOrNewSpec();
    public RouteFluent.SpecNested<A> editOrNewSpecLike(RouteSpec item);
    public RouteStatus getStatus();
    public A withStatus(RouteStatus status);
    public RouteFluent.StatusNested<A> withNewStatus();
    public RouteFluent.StatusNested<A> withNewStatusLike(RouteStatus item);
    public RouteFluent.StatusNested<A> editStatus();
    public RouteFluent.StatusNested<A> editOrNewStatus();
    public RouteFluent.StatusNested<A> editOrNewStatusLike(RouteStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<RouteFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RouteSpecFluent<RouteFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RouteStatusFluent<RouteFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
