package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface SourceBuildStrategyFluent<A extends SourceBuildStrategyFluent<A>> extends Fluent<A>{


    public A addToEnv(EnvVar... items);
    public A removeFromEnv(EnvVar... items);
    public List<EnvVar> getEnv();
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public SourceBuildStrategyFluent.EnvNested<A> addNewEnv();
    public SourceBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item);
    public Boolean isForcePull();
    public A withForcePull(Boolean forcePull);
    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public SourceBuildStrategyFluent.FromNested<A> withNewFrom();
    public SourceBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public SourceBuildStrategyFluent.FromNested<A> editFrom();
    public SourceBuildStrategyFluent.FromNested<A> editOrNewFrom();
    public SourceBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item);
    public Boolean isIncremental();
    public A withIncremental(Boolean incremental);
    public LocalObjectReference getPullSecret();
    public A withPullSecret(LocalObjectReference pullSecret);
    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecret();
    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
    public SourceBuildStrategyFluent.PullSecretNested<A> editPullSecret();
    public SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret();
    public SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item);
    public A withNewPullSecret(String name);
    public A addToRuntimeArtifacts(ImageSourcePath... items);
    public A removeFromRuntimeArtifacts(ImageSourcePath... items);
    public List<ImageSourcePath> getRuntimeArtifacts();
    public A withRuntimeArtifacts(List<ImageSourcePath> runtimeArtifacts);
    public A withRuntimeArtifacts(ImageSourcePath... runtimeArtifacts);
    public SourceBuildStrategyFluent.RuntimeArtifactsNested<A> addNewRuntimeArtifact();
    public SourceBuildStrategyFluent.RuntimeArtifactsNested<A> addNewRuntimeArtifactLike(ImageSourcePath item);
    public A addNewRuntimeArtifact(String destinationDir,String sourcePath);
    public ObjectReference getRuntimeImage();
    public A withRuntimeImage(ObjectReference runtimeImage);
    public SourceBuildStrategyFluent.RuntimeImageNested<A> withNewRuntimeImage();
    public SourceBuildStrategyFluent.RuntimeImageNested<A> withNewRuntimeImageLike(ObjectReference item);
    public SourceBuildStrategyFluent.RuntimeImageNested<A> editRuntimeImage();
    public SourceBuildStrategyFluent.RuntimeImageNested<A> editOrNewRuntimeImage();
    public SourceBuildStrategyFluent.RuntimeImageNested<A> editOrNewRuntimeImageLike(ObjectReference item);
    public String getScripts();
    public A withScripts(String scripts);

    public interface EnvNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EnvVarFluent<SourceBuildStrategyFluent.EnvNested<N>>{

        
    public N and();    public N endEnv();
}
    public interface FromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<SourceBuildStrategyFluent.FromNested<N>>{

        
    public N and();    public N endFrom();
}
    public interface PullSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<SourceBuildStrategyFluent.PullSecretNested<N>>{

        
    public N and();    public N endPullSecret();
}
    public interface RuntimeArtifactsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSourcePathFluent<SourceBuildStrategyFluent.RuntimeArtifactsNested<N>>{

        
    public N and();    public N endRuntimeArtifact();
}
    public interface RuntimeImageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<SourceBuildStrategyFluent.RuntimeImageNested<N>>{

        
    public N and();    public N endRuntimeImage();
}


}
