package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import javax.validation.Valid;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface UserFluent<A extends UserFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getFullName();
    public A withFullName(String fullName);
    public A addToGroups(String... items);
    public A removeFromGroups(String... items);
    public List<String> getGroups();
    public A withGroups(List<String> groups);
    public A withGroups(String... groups);
    public A addToIdentities(String... items);
    public A removeFromIdentities(String... items);
    public List<String> getIdentities();
    public A withIdentities(List<String> identities);
    public A withIdentities(String... identities);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public UserFluent.MetadataNested<A> withNewMetadata();
    public UserFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public UserFluent.MetadataNested<A> editMetadata();
    public UserFluent.MetadataNested<A> editOrNewMetadata();
    public UserFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<UserFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
