package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class HorizontalPodAutoscalerSpecFluentImpl<A extends HorizontalPodAutoscalerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HorizontalPodAutoscalerSpecFluent<A>{

    private CPUTargetUtilizationBuilder cpuUtilization;
    private Integer maxReplicas;
    private Integer minReplicas;
    private SubresourceReferenceBuilder scaleRef;

    public HorizontalPodAutoscalerSpecFluentImpl(){
    }
    public HorizontalPodAutoscalerSpecFluentImpl(HorizontalPodAutoscalerSpec instance){
            this.withCpuUtilization(instance.getCpuUtilization()); 
            this.withMaxReplicas(instance.getMaxReplicas()); 
            this.withMinReplicas(instance.getMinReplicas()); 
            this.withScaleRef(instance.getScaleRef()); 
    }

    
/**
 * This method has been deprecated, please use method buildCpuUtilization instead.
 */
@Deprecated public CPUTargetUtilization getCpuUtilization(){
            return this.cpuUtilization!=null?this.cpuUtilization.build():null;
    }

    public CPUTargetUtilization buildCpuUtilization(){
            return this.cpuUtilization!=null?this.cpuUtilization.build():null;
    }

    public A withCpuUtilization(CPUTargetUtilization cpuUtilization){
            _visitables.remove(this.cpuUtilization);
            if (cpuUtilization!=null){ this.cpuUtilization= new CPUTargetUtilizationBuilder(cpuUtilization); _visitables.add(this.cpuUtilization);} return (A) this;
    }

    public Boolean hasCpuUtilization(){
            return this.cpuUtilization!=null;
    }

    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<A> withNewCpuUtilization(){
            return new CpuUtilizationNestedImpl();
    }

    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<A> withNewCpuUtilizationLike(CPUTargetUtilization item){
            return new CpuUtilizationNestedImpl(item);
    }

    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<A> editCpuUtilization(){
            return withNewCpuUtilizationLike(getCpuUtilization());
    }

    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<A> editOrNewCpuUtilization(){
            return withNewCpuUtilizationLike(getCpuUtilization() != null ? getCpuUtilization(): new CPUTargetUtilizationBuilder().build());
    }

    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<A> editOrNewCpuUtilizationLike(CPUTargetUtilization item){
            return withNewCpuUtilizationLike(getCpuUtilization() != null ? getCpuUtilization(): item);
    }

    public A withNewCpuUtilization(Integer targetPercentage){
            return (A)withCpuUtilization(new CPUTargetUtilization(targetPercentage));
    }

    public Integer getMaxReplicas(){
            return this.maxReplicas;
    }

    public A withMaxReplicas(Integer maxReplicas){
            this.maxReplicas=maxReplicas; return (A) this;
    }

    public Boolean hasMaxReplicas(){
            return this.maxReplicas!=null;
    }

    public Integer getMinReplicas(){
            return this.minReplicas;
    }

    public A withMinReplicas(Integer minReplicas){
            this.minReplicas=minReplicas; return (A) this;
    }

    public Boolean hasMinReplicas(){
            return this.minReplicas!=null;
    }

    
/**
 * This method has been deprecated, please use method buildScaleRef instead.
 */
@Deprecated public SubresourceReference getScaleRef(){
            return this.scaleRef!=null?this.scaleRef.build():null;
    }

    public SubresourceReference buildScaleRef(){
            return this.scaleRef!=null?this.scaleRef.build():null;
    }

    public A withScaleRef(SubresourceReference scaleRef){
            _visitables.remove(this.scaleRef);
            if (scaleRef!=null){ this.scaleRef= new SubresourceReferenceBuilder(scaleRef); _visitables.add(this.scaleRef);} return (A) this;
    }

    public Boolean hasScaleRef(){
            return this.scaleRef!=null;
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<A> withNewScaleRef(){
            return new ScaleRefNestedImpl();
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<A> withNewScaleRefLike(SubresourceReference item){
            return new ScaleRefNestedImpl(item);
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<A> editScaleRef(){
            return withNewScaleRefLike(getScaleRef());
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<A> editOrNewScaleRef(){
            return withNewScaleRefLike(getScaleRef() != null ? getScaleRef(): new SubresourceReferenceBuilder().build());
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<A> editOrNewScaleRefLike(SubresourceReference item){
            return withNewScaleRefLike(getScaleRef() != null ? getScaleRef(): item);
    }

    public A withNewScaleRef(String apiVersion,String kind,String name,String subresource){
            return (A)withScaleRef(new SubresourceReference(apiVersion, kind, name, subresource));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl) o;
            if (cpuUtilization != null ? !cpuUtilization.equals(that.cpuUtilization) :that.cpuUtilization != null) return false;
            if (maxReplicas != null ? !maxReplicas.equals(that.maxReplicas) :that.maxReplicas != null) return false;
            if (minReplicas != null ? !minReplicas.equals(that.minReplicas) :that.minReplicas != null) return false;
            if (scaleRef != null ? !scaleRef.equals(that.scaleRef) :that.scaleRef != null) return false;
            return true;
    }


    public class CpuUtilizationNestedImpl<N> extends CPUTargetUtilizationFluentImpl<HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<N>> implements HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CPUTargetUtilizationBuilder builder;
    
            CpuUtilizationNestedImpl(CPUTargetUtilization item){
                    this.builder = new CPUTargetUtilizationBuilder(this, item);
            }
            CpuUtilizationNestedImpl(){
                    this.builder = new CPUTargetUtilizationBuilder(this);
            }
    
    public N and(){
            return (N) HorizontalPodAutoscalerSpecFluentImpl.this.withCpuUtilization(builder.build());
    }
    public N endCpuUtilization(){
            return and();
    }

}
    public class ScaleRefNestedImpl<N> extends SubresourceReferenceFluentImpl<HorizontalPodAutoscalerSpecFluent.ScaleRefNested<N>> implements HorizontalPodAutoscalerSpecFluent.ScaleRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubresourceReferenceBuilder builder;
    
            ScaleRefNestedImpl(SubresourceReference item){
                    this.builder = new SubresourceReferenceBuilder(this, item);
            }
            ScaleRefNestedImpl(){
                    this.builder = new SubresourceReferenceBuilder(this);
            }
    
    public N and(){
            return (N) HorizontalPodAutoscalerSpecFluentImpl.this.withScaleRef(builder.build());
    }
    public N endScaleRef(){
            return and();
    }

}


}
