package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;

public class PetSetSpecFluentImpl<A extends PetSetSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PetSetSpecFluent<A>{

    private Integer replicas;
    private LabelSelectorBuilder selector;
    private String serviceName;
    private PodTemplateSpecBuilder template;
    private List<PersistentVolumeClaimBuilder> volumeClaimTemplates =  new ArrayList<PersistentVolumeClaimBuilder>();

    public PetSetSpecFluentImpl(){
    }
    public PetSetSpecFluentImpl(PetSetSpec instance){
            this.withReplicas(instance.getReplicas()); 
            this.withSelector(instance.getSelector()); 
            this.withServiceName(instance.getServiceName()); 
            this.withTemplate(instance.getTemplate()); 
            this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates()); 
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return this.replicas!=null;
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 */
@Deprecated public LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public LabelSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(LabelSelector selector){
            _visitables.remove(this.selector);
            if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector!=null;
    }

    public PetSetSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public PetSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public PetSetSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public PetSetSpecFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
    }

    public PetSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public String getServiceName(){
            return this.serviceName;
    }

    public A withServiceName(String serviceName){
            this.serviceName=serviceName; return (A) this;
    }

    public Boolean hasServiceName(){
            return this.serviceName!=null;
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 */
@Deprecated public PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public PodTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(PodTemplateSpec template){
            _visitables.remove(this.template);
            if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template!=null;
    }

    public PetSetSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public PetSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public PetSetSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public PetSetSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
    }

    public PetSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public A addToVolumeClaimTemplates(int index,PersistentVolumeClaim item){
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.volumeClaimTemplates.add(index >= 0 ? index : volumeClaimTemplates.size(), builder); return (A)this;
    }

    public A setToVolumeClaimTemplates(int index,PersistentVolumeClaim item){
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= volumeClaimTemplates.size()) { volumeClaimTemplates.add(builder); } else { volumeClaimTemplates.set(index, builder);}
             return (A)this;
    }

    public A addToVolumeClaimTemplates(PersistentVolumeClaim... items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.volumeClaimTemplates.add(builder);} return (A)this;
    }

    public A addAllToVolumeClaimTemplates(Collection<PersistentVolumeClaim> items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.volumeClaimTemplates.add(builder);} return (A)this;
    }

    public A removeFromVolumeClaimTemplates(PersistentVolumeClaim... items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.remove(builder);this.volumeClaimTemplates.remove(builder);} return (A)this;
    }

    public A removeAllFromVolumeClaimTemplates(Collection<PersistentVolumeClaim> items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.remove(builder);this.volumeClaimTemplates.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumeClaimTemplates instead.
 */
@Deprecated public List<PersistentVolumeClaim> getVolumeClaimTemplates(){
            return build(volumeClaimTemplates);
    }

    public List<PersistentVolumeClaim> buildVolumeClaimTemplates(){
            return build(volumeClaimTemplates);
    }

    public PersistentVolumeClaim buildVolumeClaimTemplate(int index){
            return this.volumeClaimTemplates.get(index).build();
    }

    public PersistentVolumeClaim buildFirstVolumeClaimTemplate(){
            return this.volumeClaimTemplates.get(0).build();
    }

    public PersistentVolumeClaim buildLastVolumeClaimTemplate(){
            return this.volumeClaimTemplates.get(volumeClaimTemplates.size() - 1).build();
    }

    public PersistentVolumeClaim buildMatchingVolumeClaimTemplate(io.fabric8.kubernetes.api.builder.Predicate<PersistentVolumeClaimBuilder> predicate){
            for (PersistentVolumeClaimBuilder item: volumeClaimTemplates) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withVolumeClaimTemplates(List<PersistentVolumeClaim> volumeClaimTemplates){
            _visitables.removeAll(this.volumeClaimTemplates);
            this.volumeClaimTemplates.clear();
            if (volumeClaimTemplates != null) {for (PersistentVolumeClaim item : volumeClaimTemplates){this.addToVolumeClaimTemplates(item);}} return (A) this;
    }

    public A withVolumeClaimTemplates(PersistentVolumeClaim... volumeClaimTemplates){
            this.volumeClaimTemplates.clear(); if (volumeClaimTemplates != null) {for (PersistentVolumeClaim item :volumeClaimTemplates){ this.addToVolumeClaimTemplates(item);}} return (A) this;
    }

    public Boolean hasVolumeClaimTemplates(){
            return volumeClaimTemplates!= null && !volumeClaimTemplates.isEmpty();
    }

    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate(){
            return new VolumeClaimTemplatesNestedImpl();
    }

    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(PersistentVolumeClaim item){
            return new VolumeClaimTemplatesNestedImpl(-1, item);
    }

    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(int index,PersistentVolumeClaim item){
            return new VolumeClaimTemplatesNestedImpl(index, item);
    }

    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(int index){
            if (volumeClaimTemplates.size() <= index) throw new RuntimeException("Can't edit volumeClaimTemplates. Index exceeds size.");
            return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
    }

    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate(){
            if (volumeClaimTemplates.size() == 0) throw new RuntimeException("Can't edit first volumeClaimTemplates. The list is empty.");
            return setNewVolumeClaimTemplateLike(0, buildVolumeClaimTemplate(0));
    }

    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate(){
            int index = volumeClaimTemplates.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last volumeClaimTemplates. The list is empty.");
            return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
    }

    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(io.fabric8.kubernetes.api.builder.Predicate<PersistentVolumeClaimBuilder> predicate){
            int index = -1;
            for (int i=0;i<volumeClaimTemplates.size();i++) { 
            if (predicate.apply(volumeClaimTemplates.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching volumeClaimTemplates. No match found.");
            return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PetSetSpecFluentImpl that = (PetSetSpecFluentImpl) o;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            if (volumeClaimTemplates != null ? !volumeClaimTemplates.equals(that.volumeClaimTemplates) :that.volumeClaimTemplates != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<PetSetSpecFluent.SelectorNested<N>> implements PetSetSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LabelSelectorBuilder builder;
    
            SelectorNestedImpl(LabelSelector item){
                    this.builder = new LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) PetSetSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<PetSetSpecFluent.TemplateNested<N>> implements PetSetSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(PodTemplateSpec item){
                    this.builder = new PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) PetSetSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}
    public class VolumeClaimTemplatesNestedImpl<N> extends PersistentVolumeClaimFluentImpl<PetSetSpecFluent.VolumeClaimTemplatesNested<N>> implements PetSetSpecFluent.VolumeClaimTemplatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PersistentVolumeClaimBuilder builder;
        private final int index;
    
            VolumeClaimTemplatesNestedImpl(int index,PersistentVolumeClaim item){
                    this.index = index;
                    this.builder = new PersistentVolumeClaimBuilder(this, item);
            }
            VolumeClaimTemplatesNestedImpl(){
                    this.index = -1;
                    this.builder = new PersistentVolumeClaimBuilder(this);
            }
    
    public N and(){
            return (N) PetSetSpecFluentImpl.this.setToVolumeClaimTemplates(index, builder.build());
    }
    public N endVolumeClaimTemplate(){
            return and();
    }

}


}
