package io.fabric8.kubernetes.api.model.extensions;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class CPUTargetUtilizationFluentImpl<A extends CPUTargetUtilizationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CPUTargetUtilizationFluent<A>{

    private Integer targetPercentage;

    public CPUTargetUtilizationFluentImpl(){
    }
    public CPUTargetUtilizationFluentImpl(CPUTargetUtilization instance){
            this.withTargetPercentage(instance.getTargetPercentage()); 
    }

    public Integer getTargetPercentage(){
            return this.targetPercentage;
    }

    public A withTargetPercentage(Integer targetPercentage){
            this.targetPercentage=targetPercentage; return (A) this;
    }

    public Boolean hasTargetPercentage(){
            return this.targetPercentage!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CPUTargetUtilizationFluentImpl that = (CPUTargetUtilizationFluentImpl) o;
            if (targetPercentage != null ? !targetPercentage.equals(that.targetPercentage) :that.targetPercentage != null) return false;
            return true;
    }




}
