package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class PodStatusFluentImpl<A extends PodStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodStatusFluent<A>{

    private List<PodConditionBuilder> conditions =  new ArrayList<PodConditionBuilder>();
    private List<ContainerStatusBuilder> containerStatuses =  new ArrayList<ContainerStatusBuilder>();
    private String hostIP;
    private String message;
    private String phase;
    private String podIP;
    private String reason;
    private String startTime;

    public PodStatusFluentImpl(){
    }
    public PodStatusFluentImpl(PodStatus instance){
            this.withConditions(instance.getConditions()); 
            this.withContainerStatuses(instance.getContainerStatuses()); 
            this.withHostIP(instance.getHostIP()); 
            this.withMessage(instance.getMessage()); 
            this.withPhase(instance.getPhase()); 
            this.withPodIP(instance.getPodIP()); 
            this.withReason(instance.getReason()); 
            this.withStartTime(instance.getStartTime()); 
    }

    public A addToConditions(int index,PodCondition item){
            PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,PodCondition item){
            PodConditionBuilder builder = new PodConditionBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(PodCondition... items){
            for (PodCondition item : items) {PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<PodCondition> items){
            for (PodCondition item : items) {PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(PodCondition... items){
            for (PodCondition item : items) {PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (A)this;
    }

    public A removeAllFromConditions(Collection<PodCondition> items){
            for (PodCondition item : items) {PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 */
@Deprecated public List<PodCondition> getConditions(){
            return build(conditions);
    }

    public List<PodCondition> buildConditions(){
            return build(conditions);
    }

    public PodCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public PodCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public PodCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public PodCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<PodConditionBuilder> predicate){
            for (PodConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withConditions(List<PodCondition> conditions){
            _visitables.removeAll(this.conditions);
            this.conditions.clear();
            if (conditions != null) {for (PodCondition item : conditions){this.addToConditions(item);}} return (A) this;
    }

    public A withConditions(PodCondition... conditions){
            this.conditions.clear(); if (conditions != null) {for (PodCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions!= null && !conditions.isEmpty();
    }

    public PodStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public PodStatusFluent.ConditionsNested<A> addNewConditionLike(PodCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public PodStatusFluent.ConditionsNested<A> setNewConditionLike(int index,PodCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public PodStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public PodStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public PodStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public PodStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<PodConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public A addToContainerStatuses(int index,ContainerStatus item){
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.containerStatuses.add(index >= 0 ? index : containerStatuses.size(), builder); return (A)this;
    }

    public A setToContainerStatuses(int index,ContainerStatus item){
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= containerStatuses.size()) { containerStatuses.add(builder); } else { containerStatuses.set(index, builder);}
             return (A)this;
    }

    public A addToContainerStatuses(ContainerStatus... items){
            for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.add(builder);this.containerStatuses.add(builder);} return (A)this;
    }

    public A addAllToContainerStatuses(Collection<ContainerStatus> items){
            for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.add(builder);this.containerStatuses.add(builder);} return (A)this;
    }

    public A removeFromContainerStatuses(ContainerStatus... items){
            for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.remove(builder);this.containerStatuses.remove(builder);} return (A)this;
    }

    public A removeAllFromContainerStatuses(Collection<ContainerStatus> items){
            for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.remove(builder);this.containerStatuses.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildContainerStatuses instead.
 */
@Deprecated public List<ContainerStatus> getContainerStatuses(){
            return build(containerStatuses);
    }

    public List<ContainerStatus> buildContainerStatuses(){
            return build(containerStatuses);
    }

    public ContainerStatus buildContainerStatus(int index){
            return this.containerStatuses.get(index).build();
    }

    public ContainerStatus buildFirstContainerStatus(){
            return this.containerStatuses.get(0).build();
    }

    public ContainerStatus buildLastContainerStatus(){
            return this.containerStatuses.get(containerStatuses.size() - 1).build();
    }

    public ContainerStatus buildMatchingContainerStatus(io.fabric8.kubernetes.api.builder.Predicate<ContainerStatusBuilder> predicate){
            for (ContainerStatusBuilder item: containerStatuses) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withContainerStatuses(List<ContainerStatus> containerStatuses){
            _visitables.removeAll(this.containerStatuses);
            this.containerStatuses.clear();
            if (containerStatuses != null) {for (ContainerStatus item : containerStatuses){this.addToContainerStatuses(item);}} return (A) this;
    }

    public A withContainerStatuses(ContainerStatus... containerStatuses){
            this.containerStatuses.clear(); if (containerStatuses != null) {for (ContainerStatus item :containerStatuses){ this.addToContainerStatuses(item);}} return (A) this;
    }

    public Boolean hasContainerStatuses(){
            return containerStatuses!= null && !containerStatuses.isEmpty();
    }

    public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus(){
            return new ContainerStatusesNestedImpl();
    }

    public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item){
            return new ContainerStatusesNestedImpl(-1, item);
    }

    public PodStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(int index,ContainerStatus item){
            return new ContainerStatusesNestedImpl(index, item);
    }

    public PodStatusFluent.ContainerStatusesNested<A> editContainerStatus(int index){
            if (containerStatuses.size() <= index) throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
            return setNewContainerStatusLike(index, buildContainerStatus(index));
    }

    public PodStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus(){
            if (containerStatuses.size() == 0) throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
            return setNewContainerStatusLike(0, buildContainerStatus(0));
    }

    public PodStatusFluent.ContainerStatusesNested<A> editLastContainerStatus(){
            int index = containerStatuses.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
            return setNewContainerStatusLike(index, buildContainerStatus(index));
    }

    public PodStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(io.fabric8.kubernetes.api.builder.Predicate<ContainerStatusBuilder> predicate){
            int index = -1;
            for (int i=0;i<containerStatuses.size();i++) { 
            if (predicate.apply(containerStatuses.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
            return setNewContainerStatusLike(index, buildContainerStatus(index));
    }

    public String getHostIP(){
            return this.hostIP;
    }

    public A withHostIP(String hostIP){
            this.hostIP=hostIP; return (A) this;
    }

    public Boolean hasHostIP(){
            return this.hostIP!=null;
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message!=null;
    }

    public String getPhase(){
            return this.phase;
    }

    public A withPhase(String phase){
            this.phase=phase; return (A) this;
    }

    public Boolean hasPhase(){
            return this.phase!=null;
    }

    public String getPodIP(){
            return this.podIP;
    }

    public A withPodIP(String podIP){
            this.podIP=podIP; return (A) this;
    }

    public Boolean hasPodIP(){
            return this.podIP!=null;
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason!=null;
    }

    public String getStartTime(){
            return this.startTime;
    }

    public A withStartTime(String startTime){
            this.startTime=startTime; return (A) this;
    }

    public Boolean hasStartTime(){
            return this.startTime!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PodStatusFluentImpl that = (PodStatusFluentImpl) o;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (containerStatuses != null ? !containerStatuses.equals(that.containerStatuses) :that.containerStatuses != null) return false;
            if (hostIP != null ? !hostIP.equals(that.hostIP) :that.hostIP != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
            if (podIP != null ? !podIP.equals(that.podIP) :that.podIP != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends PodConditionFluentImpl<PodStatusFluent.ConditionsNested<N>> implements PodStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,PodCondition item){
                    this.index = index;
                    this.builder = new PodConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new PodConditionBuilder(this);
            }
    
    public N and(){
            return (N) PodStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class ContainerStatusesNestedImpl<N> extends ContainerStatusFluentImpl<PodStatusFluent.ContainerStatusesNested<N>> implements PodStatusFluent.ContainerStatusesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerStatusBuilder builder;
        private final int index;
    
            ContainerStatusesNestedImpl(int index,ContainerStatus item){
                    this.index = index;
                    this.builder = new ContainerStatusBuilder(this, item);
            }
            ContainerStatusesNestedImpl(){
                    this.index = -1;
                    this.builder = new ContainerStatusBuilder(this);
            }
    
    public N and(){
            return (N) PodStatusFluentImpl.this.setToContainerStatuses(index, builder.build());
    }
    public N endContainerStatus(){
            return and();
    }

}


}
