package io.fabric8.kubernetes.api.model.extensions;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class DaemonSetStatusFluentImpl<A extends DaemonSetStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DaemonSetStatusFluent<A>{

    private Integer currentNumberScheduled;
    private Integer desiredNumberScheduled;
    private Integer numberMisscheduled;
    private Integer numberReady;

    public DaemonSetStatusFluentImpl(){
    }
    public DaemonSetStatusFluentImpl(DaemonSetStatus instance){
            this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled()); 
            this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled()); 
            this.withNumberMisscheduled(instance.getNumberMisscheduled()); 
            this.withNumberReady(instance.getNumberReady()); 
    }

    public Integer getCurrentNumberScheduled(){
            return this.currentNumberScheduled;
    }

    public A withCurrentNumberScheduled(Integer currentNumberScheduled){
            this.currentNumberScheduled=currentNumberScheduled; return (A) this;
    }

    public Boolean hasCurrentNumberScheduled(){
            return this.currentNumberScheduled!=null;
    }

    public Integer getDesiredNumberScheduled(){
            return this.desiredNumberScheduled;
    }

    public A withDesiredNumberScheduled(Integer desiredNumberScheduled){
            this.desiredNumberScheduled=desiredNumberScheduled; return (A) this;
    }

    public Boolean hasDesiredNumberScheduled(){
            return this.desiredNumberScheduled!=null;
    }

    public Integer getNumberMisscheduled(){
            return this.numberMisscheduled;
    }

    public A withNumberMisscheduled(Integer numberMisscheduled){
            this.numberMisscheduled=numberMisscheduled; return (A) this;
    }

    public Boolean hasNumberMisscheduled(){
            return this.numberMisscheduled!=null;
    }

    public Integer getNumberReady(){
            return this.numberReady;
    }

    public A withNumberReady(Integer numberReady){
            this.numberReady=numberReady; return (A) this;
    }

    public Boolean hasNumberReady(){
            return this.numberReady!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DaemonSetStatusFluentImpl that = (DaemonSetStatusFluentImpl) o;
            if (currentNumberScheduled != null ? !currentNumberScheduled.equals(that.currentNumberScheduled) :that.currentNumberScheduled != null) return false;
            if (desiredNumberScheduled != null ? !desiredNumberScheduled.equals(that.desiredNumberScheduled) :that.desiredNumberScheduled != null) return false;
            if (numberMisscheduled != null ? !numberMisscheduled.equals(that.numberMisscheduled) :that.numberMisscheduled != null) return false;
            if (numberReady != null ? !numberReady.equals(that.numberReady) :that.numberReady != null) return false;
            return true;
    }




}
