package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ThirdPartyResourceBuilder extends ThirdPartyResourceFluentImpl<ThirdPartyResourceBuilder> implements VisitableBuilder<ThirdPartyResource,ThirdPartyResourceBuilder>{

    ThirdPartyResourceFluent<?> fluent;
    Boolean validationEnabled;

    public ThirdPartyResourceBuilder(){
            this(true);
    }
    public ThirdPartyResourceBuilder(Boolean validationEnabled){
            this(new ThirdPartyResource(), validationEnabled);
    }
    public ThirdPartyResourceBuilder(ThirdPartyResourceFluent<?> fluent){
            this(fluent, true);
    }
    public ThirdPartyResourceBuilder(ThirdPartyResourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ThirdPartyResource(), validationEnabled);
    }
    public ThirdPartyResourceBuilder(ThirdPartyResourceFluent<?> fluent,ThirdPartyResource instance){
            this(fluent, instance, true);
    }
    public ThirdPartyResourceBuilder(ThirdPartyResourceFluent<?> fluent,ThirdPartyResource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withDescription(instance.getDescription()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withVersions(instance.getVersions()); 
            this.validationEnabled = validationEnabled; 
    }
    public ThirdPartyResourceBuilder(ThirdPartyResource instance){
            this(instance,true);
    }
    public ThirdPartyResourceBuilder(ThirdPartyResource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withDescription(instance.getDescription()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withVersions(instance.getVersions()); 
            this.validationEnabled = validationEnabled; 
    }

    public ThirdPartyResource build(){
            ThirdPartyResource buildable = new ThirdPartyResource(fluent.getApiVersion(),fluent.getDescription(),fluent.getKind(),fluent.getMetadata(),fluent.getVersions());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ThirdPartyResourceBuilder that = (ThirdPartyResourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
