package io.fabric8.kubernetes.api.model;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface ISCSIVolumeSourceFluent<A extends ISCSIVolumeSourceFluent<A>> extends Fluent<A>{


    public String getFsType();
    public A withFsType(String fsType);
    public Boolean hasFsType();
    public String getIqn();
    public A withIqn(String iqn);
    public Boolean hasIqn();
    public String getIscsiInterface();
    public A withIscsiInterface(String iscsiInterface);
    public Boolean hasIscsiInterface();
    public Integer getLun();
    public A withLun(Integer lun);
    public Boolean hasLun();
    public Boolean isReadOnly();
    public A withReadOnly(Boolean readOnly);
    public Boolean hasReadOnly();
    public String getTargetPortal();
    public A withTargetPortal(String targetPortal);
    public Boolean hasTargetPortal();



}
